/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPBaseNamedObject;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternExprPrecedenceEnum;
import com.espertech.esper.pattern.guard.GuardEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatternGuardExpr
extends EPBaseNamedObject
implements PatternExpr {
    private static final long serialVersionUID = 0L;
    private String treeObjectName;
    private List<PatternExpr> guarded = new ArrayList<PatternExpr>();

    public PatternGuardExpr(String namespace, String name, List<Expression> parameters) {
        super(namespace, name, parameters);
    }

    public PatternGuardExpr(String namespace, String name, Expression[] parameters, PatternExpr guarded) {
        this(namespace, name, Arrays.asList(parameters), guarded);
    }

    public PatternGuardExpr(String namespace, String name, List<Expression> parameters, PatternExpr guardedPattern) {
        super(namespace, name, parameters);
        this.guarded.add(guardedPattern);
    }

    @Override
    public List<PatternExpr> getChildren() {
        return this.guarded;
    }

    public void setGuarded(List<PatternExpr> guarded) {
        this.guarded = guarded;
    }

    public List<PatternExpr> getGuarded() {
        return this.guarded;
    }

    @Override
    public String getTreeObjectName() {
        return this.treeObjectName;
    }

    @Override
    public void setTreeObjectName(String treeObjectName) {
        this.treeObjectName = treeObjectName;
    }

    @Override
    public PatternExprPrecedenceEnum getPrecedence() {
        return PatternExprPrecedenceEnum.GUARD;
    }

    @Override
    public final void toEPL(StringWriter writer, PatternExprPrecedenceEnum parentPrecedence, EPStatementFormatter formatter) {
        if (this.getPrecedence().getLevel() < parentPrecedence.getLevel()) {
            writer.write("(");
            this.toPrecedenceFreeEPL(writer, formatter);
            writer.write(")");
        } else {
            this.toPrecedenceFreeEPL(writer, formatter);
        }
    }

    public void toPrecedenceFreeEPL(StringWriter writer, EPStatementFormatter formatter) {
        this.guarded.get(0).toEPL(writer, this.getPrecedence(), formatter);
        if (GuardEnum.isWhile(this.getNamespace(), this.getName())) {
            writer.write(" while (");
            this.getParameters().get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.write(")");
        } else {
            writer.write(" where ");
            super.toEPL(writer);
        }
    }

    @Override
    public void setChildren(List<PatternExpr> children) {
        this.guarded = children;
    }
}

