/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayBackedCollection<T>
implements Collection<T> {
    private int lastIndex;
    private int currentIndex;
    private Object[] handles;

    public ArrayBackedCollection(int currentSize) {
        this.lastIndex = currentSize - 1;
        this.currentIndex = 0;
        this.handles = new Object[currentSize];
    }

    @Override
    public boolean add(T object) {
        if (this.currentIndex <= this.lastIndex) {
            this.handles[this.currentIndex++] = object;
            return true;
        }
        int newSize = this.lastIndex * 2 + 2;
        Object[] newHandles = new Object[newSize];
        System.arraycopy(this.handles, 0, newHandles, 0, this.handles.length);
        this.handles = newHandles;
        this.lastIndex = newSize - 1;
        this.handles[this.currentIndex++] = object;
        return true;
    }

    @Override
    public void clear() {
        this.currentIndex = 0;
    }

    @Override
    public int size() {
        return this.currentIndex;
    }

    public Object[] getArray() {
        return this.handles;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayBackedCollectionIterator(this.handles, this.currentIndex);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public class ArrayBackedCollectionIterator
    implements Iterator<T> {
        private final Object[] items;
        private final int lastIndex;
        private int position;

        public ArrayBackedCollectionIterator(Object[] items, int lastIndex) {
            this.items = items;
            this.lastIndex = lastIndex;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.lastIndex;
        }

        @Override
        public T next() {
            if (this.position >= this.lastIndex) {
                throw new NoSuchElementException();
            }
            return this.items[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

