/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatementAgentInstancePostLoadSelect
implements StatementAgentInstancePostLoad {
    private final Viewable[] streamViews;
    private final JoinSetComposerDesc joinSetComposer;
    private final NamedWindowTailViewInstance[] namedWindowTailViews;
    private final FilterSpecCompiled[] namedWindowPostloadFilters;
    private final List<ExprNode>[] namedWindowFilters;
    private final Annotation[] annotations;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public StatementAgentInstancePostLoadSelect(Viewable[] streamViews, JoinSetComposerDesc joinSetComposer, NamedWindowTailViewInstance[] namedWindowTailViews, FilterSpecCompiled[] namedWindowPostloadFilters, List<ExprNode>[] namedWindowFilters, Annotation[] annotations, ExprEvaluatorContext exprEvaluatorContext) {
        this.streamViews = streamViews;
        this.joinSetComposer = joinSetComposer;
        this.namedWindowTailViews = namedWindowTailViews;
        this.namedWindowPostloadFilters = namedWindowPostloadFilters;
        this.namedWindowFilters = namedWindowFilters;
        this.annotations = annotations;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public void executePostLoad() {
        if (this.joinSetComposer == null || !this.joinSetComposer.getJoinSetComposer().allowsInit()) {
            return;
        }
        EventBean[][] events = new EventBean[this.streamViews.length][];
        for (int stream = 0; stream < this.streamViews.length; ++stream) {
            Collection<Object> eventsInWindow;
            Viewable streamView = this.streamViews[stream];
            if (streamView instanceof HistoricalEventViewable) continue;
            if (this.namedWindowTailViews[stream] != null) {
                NamedWindowTailViewInstance nwtail = this.namedWindowTailViews[stream];
                Collection<EventBean> snapshot = nwtail.snapshotNoLock(this.namedWindowPostloadFilters[stream], this.annotations);
                if (this.namedWindowFilters[stream] != null) {
                    eventsInWindow = new ArrayList(snapshot.size());
                    ExprNodeUtility.applyFilterExpressionsIterable(snapshot, this.namedWindowFilters[stream], this.exprEvaluatorContext, eventsInWindow);
                } else {
                    eventsInWindow = snapshot;
                }
            } else if (this.namedWindowFilters[stream] != null && !this.namedWindowFilters[stream].isEmpty()) {
                eventsInWindow = new ArrayDeque();
                ExprNodeUtility.applyFilterExpressionsIterable(this.streamViews[stream], this.namedWindowFilters[stream], this.exprEvaluatorContext, eventsInWindow);
            } else {
                eventsInWindow = new ArrayDeque();
                for (EventBean aConsumerView : this.streamViews[stream]) {
                    eventsInWindow.add(aConsumerView);
                }
            }
            events[stream] = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
        }
        this.joinSetComposer.getJoinSetComposer().init(events);
    }

    @Override
    public void acceptIndexVisitor(StatementAgentInstancePostLoadIndexVisitor visitor) {
    }
}

