/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.mgr.AgentInstance;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AgentInstanceArrayIterator
implements Iterator<EventBean> {
    protected final AgentInstance[] instances;
    private int currentIndex;
    private Iterator<EventBean> currentIterator;

    public AgentInstanceArrayIterator(AgentInstance[] instances) {
        this.instances = instances;
        if (instances.length > 0) {
            this.currentIterator = instances[0].getFinalView().iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        this.moveNext();
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public EventBean next() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        this.moveNext();
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    private void moveNext() {
        if (this.currentIndex >= this.instances.length - 1) {
            return;
        }
        do {
            ++this.currentIndex;
            this.currentIterator = this.instances[this.currentIndex].getFinalView().iterator();
        } while (this.currentIndex < this.instances.length - 1 && !this.currentIterator.hasNext());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

