/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.spec.ContextDetailConditionPattern;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.EvalRootState;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.MatchedEventMapImpl;
import com.espertech.esper.pattern.MatchedEventMapMeta;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternMatchCallback;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ContextControllerConditionPattern
implements ContextControllerCondition,
PatternMatchCallback {
    private final EPServicesContext servicesContext;
    private final AgentInstanceContext agentInstanceContext;
    private final ContextDetailConditionPattern endpointPatternSpec;
    private final ContextControllerConditionCallback callback;
    private final ContextInternalFilterAddendum filterAddendum;
    private final boolean isStartEndpoint;
    private final ContextStatePathKey contextStatePathKey;
    protected EvalRootState patternStopCallback;

    public ContextControllerConditionPattern(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContext, ContextDetailConditionPattern endpointPatternSpec, ContextControllerConditionCallback callback, ContextInternalFilterAddendum filterAddendum, boolean startEndpoint, ContextStatePathKey contextStatePathKey) {
        this.servicesContext = servicesContext;
        this.agentInstanceContext = agentInstanceContext;
        this.endpointPatternSpec = endpointPatternSpec;
        this.callback = callback;
        this.filterAddendum = filterAddendum;
        this.isStartEndpoint = startEndpoint;
        this.contextStatePathKey = contextStatePathKey;
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, MatchedEventMap priorMatches, long timeOffset, boolean isRecoveringReslient) {
        if (this.patternStopCallback != null) {
            this.patternStopCallback.stop();
        }
        PatternStreamSpecCompiled patternStreamSpec = this.endpointPatternSpec.getPatternCompiled();
        StatementContext stmtContext = this.agentInstanceContext.getStatementContext();
        EvalRootFactoryNode rootFactoryNode = this.servicesContext.getPatternNodeFactory().makeRootNode(patternStreamSpec.getEvalFactoryNode());
        int streamNum = this.isStartEndpoint ? this.contextStatePathKey.getSubPath() : -1 * this.contextStatePathKey.getSubPath();
        boolean allowResilient = this.contextStatePathKey.getLevel() == 1;
        PatternContext patternContext = stmtContext.getPatternContextFactory().createContext(stmtContext, streamNum, rootFactoryNode, new MatchedEventMapMeta(patternStreamSpec.getAllTags(), !patternStreamSpec.getArrayEventTypes().isEmpty()), allowResilient);
        PatternAgentInstanceContext patternAgentInstanceContext = stmtContext.getPatternContextFactory().createPatternAgentContext(patternContext, this.agentInstanceContext, false);
        EvalRootNode rootNode = EvalNodeUtil.makeRootNodeFromFactory(rootFactoryNode, patternAgentInstanceContext);
        if (priorMatches == null) {
            priorMatches = new MatchedEventMapImpl(patternContext.getMatchedEventMapMeta());
        }
        ConditionPatternMatchCallback callback = new ConditionPatternMatchCallback(this);
        this.patternStopCallback = rootNode.start(callback, patternContext, priorMatches, isRecoveringReslient);
        callback.forwardCalls = true;
        if (this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext() != null && this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources() != null) {
            this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources().startContextPattern(this.patternStopCallback, this.isStartEndpoint, this.contextStatePathKey);
        }
        if (callback.isInvoked) {
            this.matchFound(Collections.emptyMap());
        }
    }

    @Override
    public void matchFound(Map<String, Object> matchEvent) {
        Map<String, Object> matchEventInclusive = null;
        if (this.endpointPatternSpec.isInclusive()) {
            if (matchEvent.size() < 2) {
                matchEventInclusive = matchEvent;
            } else {
                LinkedHashMap<String, Object> ordered = new LinkedHashMap<String, Object>();
                for (String key : this.endpointPatternSpec.getPatternCompiled().getTaggedEventTypes().keySet()) {
                    ordered.put(key, matchEvent.get(key));
                }
                for (String key : this.endpointPatternSpec.getPatternCompiled().getArrayEventTypes().keySet()) {
                    ordered.put(key, matchEvent.get(key));
                }
                matchEventInclusive = ordered;
            }
        }
        this.callback.rangeNotification(matchEvent, this, null, matchEventInclusive, this.filterAddendum);
    }

    @Override
    public void deactivate() {
        if (this.patternStopCallback != null) {
            this.patternStopCallback.stop();
            this.patternStopCallback = null;
            if (this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext() != null && this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources() != null) {
                this.agentInstanceContext.getStatementContext().getStatementExtensionServicesContext().getStmtResources().stopContextPattern(this.isStartEndpoint, this.contextStatePathKey);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.patternStopCallback != null;
    }

    @Override
    public Long getExpectedEndTime() {
        return null;
    }

    @Override
    public boolean isImmediate() {
        return this.endpointPatternSpec.isImmediate();
    }

    public static class ConditionPatternMatchCallback
    implements PatternMatchCallback {
        private final ContextControllerConditionPattern condition;
        private boolean isInvoked;
        private boolean forwardCalls;

        public ConditionPatternMatchCallback(ContextControllerConditionPattern condition) {
            this.condition = condition;
        }

        @Override
        public void matchFound(Map<String, Object> matchEvent) {
            this.isInvoked = true;
            if (this.forwardCalls) {
                this.condition.matchFound(matchEvent);
            }
        }

        public boolean isInvoked() {
            return this.isInvoked;
        }
    }
}

