/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.ExceptionHandlerExceptionType;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryServiceContext;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.context.mgr.ContextManager;
import com.espertech.esper.core.context.mgr.ContextManagerEntry;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExceptionHandlingService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.CreateContextDesc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagementServiceImpl
implements ContextManagementService {
    private static final Logger log = LoggerFactory.getLogger(ContextManagementServiceImpl.class);
    private final Map<String, ContextManagerEntry> contexts;
    private final Set<String> destroyedContexts = new HashSet<String>();

    public ContextManagementServiceImpl() {
        this.contexts = new HashMap<String, ContextManagerEntry>();
    }

    @Override
    public void addContextSpec(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContext, CreateContextDesc contextDesc, boolean isRecoveringResilient, EventType statementResultEventType) throws ExprValidationException {
        ContextManagerEntry mgr = this.contexts.get(contextDesc.getContextName());
        if (mgr != null) {
            if (this.destroyedContexts.contains(contextDesc.getContextName())) {
                throw new ExprValidationException("Context by name '" + contextDesc.getContextName() + "' is still referenced by statements and may not be changed");
            }
            throw new ExprValidationException("Context by name '" + contextDesc.getContextName() + "' already exists");
        }
        ContextControllerFactoryServiceContext factoryServiceContext = new ContextControllerFactoryServiceContext(contextDesc.getContextName(), servicesContext, contextDesc.getContextDetail(), agentInstanceContext, isRecoveringResilient, statementResultEventType);
        ContextManager contextManager = servicesContext.getContextManagerFactoryService().make(contextDesc.getContextDetail(), factoryServiceContext);
        factoryServiceContext.getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().setFilterFaultHandler(contextManager);
        this.contexts.put(contextDesc.getContextName(), new ContextManagerEntry(contextManager));
    }

    @Override
    public int getContextCount() {
        return this.contexts.size();
    }

    @Override
    public ContextDescriptor getContextDescriptor(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            return null;
        }
        return entry.getContextManager().getContextDescriptor();
    }

    @Override
    public ContextManager getContextManager(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            return null;
        }
        return entry.getContextManager();
    }

    @Override
    public void addStatement(String contextName, ContextControllerStatementBase statement, boolean isRecoveringResilient) throws ExprValidationException {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            throw new ExprValidationException(this.getNotDecaredText(contextName));
        }
        entry.addStatement(statement.getStatementContext().getStatementId());
        entry.getContextManager().addStatement(statement, isRecoveringResilient);
    }

    @Override
    public void destroyedStatement(String contextName, String statementName, int statementId) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn("Destroy statement for statement '" + statementName + "' failed to locate corresponding context manager '" + contextName + "'");
            return;
        }
        entry.removeStatement(statementId);
        entry.getContextManager().destroyStatement(statementName, statementId);
        if (entry.getStatementCount() == 0 && this.destroyedContexts.contains(contextName)) {
            this.destroyContext(contextName, entry);
        }
    }

    @Override
    public void stoppedStatement(String contextName, String statementName, int statementId, String epl, ExceptionHandlingService exceptionHandlingService) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn("Stop statement for statement '" + statementName + "' failed to locate corresponding context manager '" + contextName + "'");
            return;
        }
        try {
            entry.getContextManager().stopStatement(statementName, statementId);
        }
        catch (RuntimeException ex) {
            exceptionHandlingService.handleException(ex, statementName, epl, ExceptionHandlerExceptionType.STOP, null);
        }
    }

    @Override
    public void destroyedContext(String contextName) {
        ContextManagerEntry entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn("Destroy for context '" + contextName + "' failed to locate corresponding context manager '" + contextName + "'");
            return;
        }
        if (entry.getStatementCount() == 0) {
            this.destroyContext(contextName, entry);
        } else {
            this.destroyedContexts.add(contextName);
        }
    }

    @Override
    public Map<String, ContextManagerEntry> getContexts() {
        return this.contexts;
    }

    private void destroyContext(String contextName, ContextManagerEntry entry) {
        entry.getContextManager().safeDestroy();
        this.contexts.remove(contextName);
        this.destroyedContexts.remove(contextName);
    }

    private String getNotDecaredText(String contextName) {
        return "Context by name '" + contextName + "' has not been declared";
    }
}

