/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailCondition;
import com.espertech.esper.epl.spec.ContextDetailConditionFilter;
import com.espertech.esper.epl.spec.ContextDetailConditionPattern;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextPropertyEventType {
    public static final String PROP_CTX_NAME = "name";
    public static final String PROP_CTX_ID = "id";
    public static final String PROP_CTX_LABEL = "label";
    public static final String PROP_CTX_STARTTIME = "startTime";
    public static final String PROP_CTX_ENDTIME = "endTime";
    public static final String PROP_CTX_KEY_PREFIX = "key";
    private static final List<ContextProperty> LIST_INITIATEDTERM_PROPS = new ArrayList<ContextProperty>();
    private static final List<ContextProperty> LIST_CATEGORY_PROPS;
    private static final List<ContextProperty> LIST_PARTITION_PROPS;
    private static final List<ContextProperty> LIST_HASH_PROPS;
    private static final List<ContextProperty> LIST_NESTED_PROPS;

    public static Map<String, Object> getCategorizedType() {
        return ContextPropertyEventType.makeEventType(LIST_CATEGORY_PROPS, Collections.emptyMap());
    }

    public static Map<String, Object> getCategorizedBean(String contextName, int agentInstanceId, String label) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_CTX_NAME, contextName);
        props.put(PROP_CTX_ID, agentInstanceId);
        props.put(PROP_CTX_LABEL, label);
        return props;
    }

    public static Map<String, Object> getInitiatedTerminatedType() {
        return ContextPropertyEventType.makeEventType(LIST_INITIATEDTERM_PROPS, Collections.EMPTY_MAP);
    }

    public static void addEndpointTypes(String contextName, ContextDetailCondition endpoint, Map<String, Object> properties, Set<String> allTags) throws ExprValidationException {
        ContextDetailConditionFilter filter;
        if (endpoint instanceof ContextDetailConditionFilter && (filter = (ContextDetailConditionFilter)endpoint).getOptionalFilterAsName() != null) {
            if (properties.containsKey(filter.getOptionalFilterAsName())) {
                throw new ExprValidationException("For context '" + contextName + "' the stream or tag name '" + filter.getOptionalFilterAsName() + "' is already declared");
            }
            allTags.add(filter.getOptionalFilterAsName());
            properties.put(filter.getOptionalFilterAsName(), filter.getFilterSpecCompiled().getFilterForEventType());
        }
        if (endpoint instanceof ContextDetailConditionPattern) {
            ContextDetailConditionPattern pattern = (ContextDetailConditionPattern)endpoint;
            for (Map.Entry<String, Pair<EventType, String>> entry : pattern.getPatternCompiled().getTaggedEventTypes().entrySet()) {
                if (properties.containsKey(entry.getKey()) && !properties.get(entry.getKey()).equals(entry.getValue().getFirst())) {
                    throw new ExprValidationException("For context '" + contextName + "' the stream or tag name '" + entry.getKey() + "' is already declared");
                }
                allTags.add(entry.getKey());
                properties.put(entry.getKey(), entry.getValue().getFirst());
            }
        }
    }

    public static Map<String, Object> getTempOverlapBean(String contextName, int agentInstanceId, Map<String, Object> matchEvent, EventBean theEvent, String filterAsName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_CTX_NAME, contextName);
        props.put(PROP_CTX_ID, agentInstanceId);
        if (matchEvent != null) {
            props.putAll(matchEvent);
        } else {
            props.put(filterAsName, theEvent);
        }
        return props;
    }

    public static Map<String, Object> getPartitionType(ContextDetailPartitioned segmentedSpec, Class[] propertyTypes) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (int i = 0; i < segmentedSpec.getItems().get(0).getPropertyNames().size(); ++i) {
            String propertyName = PROP_CTX_KEY_PREFIX + (i + 1);
            props.put(propertyName, propertyTypes[i]);
        }
        return ContextPropertyEventType.makeEventType(LIST_PARTITION_PROPS, props);
    }

    public static Map<String, Object> getPartitionBean(String contextName, int agentInstanceId, Object keyValue, List<String> propertyNames) {
        Object[] agentInstanceProperties = propertyNames.size() == 1 ? new Object[]{keyValue} : ((MultiKeyUntyped)keyValue).getKeys();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_CTX_NAME, contextName);
        props.put(PROP_CTX_ID, agentInstanceId);
        for (int i = 0; i < agentInstanceProperties.length; ++i) {
            String propertyName = PROP_CTX_KEY_PREFIX + (i + 1);
            props.put(propertyName, agentInstanceProperties[i]);
        }
        return props;
    }

    public static Map<String, Object> getNestedTypeBase() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        return ContextPropertyEventType.makeEventType(LIST_NESTED_PROPS, props);
    }

    public static Map<String, Object> getNestedBeanBase(String contextName, int contextPartitionId) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put(PROP_CTX_NAME, contextName);
        props.put(PROP_CTX_ID, contextPartitionId);
        return props;
    }

    public static Map<String, Object> getHashType() {
        return ContextPropertyEventType.makeEventType(LIST_HASH_PROPS, Collections.EMPTY_MAP);
    }

    public static Map<String, Object> getHashBean(String contextName, int agentInstanceId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PROP_CTX_NAME, contextName);
        props.put(PROP_CTX_ID, agentInstanceId);
        return props;
    }

    private static Map<String, Object> makeEventType(List<ContextProperty> builtin, Map<String, Object> additionalProperties) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(additionalProperties);
        for (ContextProperty prop : builtin) {
            properties.put(prop.getPropertyName(), prop.getPropertyType());
        }
        return properties;
    }

    static {
        LIST_INITIATEDTERM_PROPS.add(new ContextProperty(PROP_CTX_ID, Integer.TYPE));
        LIST_INITIATEDTERM_PROPS.add(new ContextProperty(PROP_CTX_NAME, String.class));
        LIST_INITIATEDTERM_PROPS.add(new ContextProperty(PROP_CTX_STARTTIME, Long.TYPE));
        LIST_INITIATEDTERM_PROPS.add(new ContextProperty(PROP_CTX_ENDTIME, Long.TYPE));
        LIST_CATEGORY_PROPS = new ArrayList<ContextProperty>();
        LIST_CATEGORY_PROPS.add(new ContextProperty(PROP_CTX_NAME, String.class));
        LIST_CATEGORY_PROPS.add(new ContextProperty(PROP_CTX_ID, Integer.TYPE));
        LIST_CATEGORY_PROPS.add(new ContextProperty(PROP_CTX_LABEL, String.class));
        LIST_PARTITION_PROPS = new ArrayList<ContextProperty>();
        LIST_PARTITION_PROPS.add(new ContextProperty(PROP_CTX_NAME, String.class));
        LIST_PARTITION_PROPS.add(new ContextProperty(PROP_CTX_ID, Integer.TYPE));
        LIST_HASH_PROPS = new ArrayList<ContextProperty>();
        LIST_HASH_PROPS.add(new ContextProperty(PROP_CTX_NAME, String.class));
        LIST_HASH_PROPS.add(new ContextProperty(PROP_CTX_ID, Integer.TYPE));
        LIST_NESTED_PROPS = new ArrayList<ContextProperty>();
        LIST_NESTED_PROPS.add(new ContextProperty(PROP_CTX_NAME, String.class));
        LIST_NESTED_PROPS.add(new ContextProperty(PROP_CTX_ID, Integer.TYPE));
    }

    public static class ContextProperty {
        private final String propertyName;
        private final Class propertyType;

        public ContextProperty(String propertyName, Class propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }
    }
}

