/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPPreparedStatement;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.context.EPContextPartitionAdmin;
import com.espertech.esper.client.deploy.EPDeploymentAdmin;
import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.core.deploy.EPDeploymentAdminImpl;
import com.espertech.esper.core.service.EPAdministratorContext;
import com.espertech.esper.core.service.EPAdministratorHelper;
import com.espertech.esper.core.service.EPAdministratorSPI;
import com.espertech.esper.core.service.EPContextPartitionAdminImpl;
import com.espertech.esper.core.service.EPPreparedStatementImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecMapper;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StatementSpecUnMapResult;
import com.espertech.esper.pattern.EvalFactoryNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPAdministratorImpl
implements EPAdministratorSPI {
    private static final String SUBS_PARAM_INVALID_USE = "Invalid use of substitution parameters marked by '?' in statement, use the prepare method to prepare statements with substitution parameters";
    private EPServicesContext services;
    private ConfigurationOperations configurationOperations;
    private SelectClauseStreamSelectorEnum defaultStreamSelector;
    private EPDeploymentAdmin deploymentAdminService;
    private static Logger log = LoggerFactory.getLogger(EPAdministratorImpl.class);

    public EPAdministratorImpl(EPAdministratorContext adminContext) {
        this.services = adminContext.getServices();
        this.configurationOperations = adminContext.getConfigurationOperations();
        this.defaultStreamSelector = adminContext.getDefaultStreamSelector();
        this.deploymentAdminService = new EPDeploymentAdminImpl(this, this.services.getEventProcessingRWLock(), adminContext.getServices().getDeploymentStateService(), adminContext.getServices().getStatementEventTypeRefService(), adminContext.getServices().getEventAdapterService(), adminContext.getServices().getStatementIsolationService(), adminContext.getServices().getFilterService(), this.services.getConfigSnapshot().getEngineDefaults().getExpression().getTimeZone(), this.services.getConfigSnapshot().getEngineDefaults().getExceptionHandling().getUndeployRethrowPolicy());
    }

    @Override
    public EPDeploymentAdmin getDeploymentAdmin() {
        return this.deploymentAdminService;
    }

    @Override
    public EPStatement createPattern(String onExpression) throws EPException {
        return this.createPatternStmt(onExpression, null, null, null);
    }

    @Override
    public EPStatement createEPL(String eplStatement) throws EPException {
        return this.createEPLStmt(eplStatement, null, null, null);
    }

    @Override
    public EPStatement createPattern(String expression, String statementName) throws EPException {
        return this.createPatternStmt(expression, statementName, null, null);
    }

    @Override
    public EPStatement createPattern(String expression, String statementName, Object userObject) throws EPException {
        return this.createPatternStmt(expression, statementName, userObject, null);
    }

    @Override
    public EPStatement createEPL(String eplStatement, String statementName) throws EPException {
        return this.createEPLStmt(eplStatement, statementName, null, null);
    }

    @Override
    public EPStatement createEPLStatementId(String eplStatement, String statementName, Object userObject, int statementId) throws EPException {
        return this.createEPLStmt(eplStatement, statementName, userObject, statementId);
    }

    @Override
    public EPStatement createEPL(String eplStatement, String statementName, Object userObject) throws EPException {
        return this.createEPLStmt(eplStatement, statementName, userObject, null);
    }

    @Override
    public EPStatement createPattern(String expression, Object userObject) throws EPException {
        return this.createPatternStmt(expression, null, userObject, null);
    }

    @Override
    public EPStatement createPatternStatementId(String pattern, String statementName, Object userObject, int statementId) throws EPException {
        return this.createPatternStmt(pattern, statementName, userObject, statementId);
    }

    @Override
    public EPStatement createEPL(String eplStatement, Object userObject) throws EPException {
        return this.createEPLStmt(eplStatement, null, userObject, null);
    }

    private EPStatement createPatternStmt(String expression, String statementName, Object userObject, Integer optionalStatementId) throws EPException {
        StatementSpecRaw rawPattern = EPAdministratorHelper.compilePattern(expression, expression, true, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return this.services.getStatementLifecycleSvc().createAndStart(rawPattern, expression, true, statementName, userObject, null, optionalStatementId, null);
    }

    private EPStatement createEPLStmt(String eplStatement, String statementName, Object userObject, Integer optionalStatementId) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorHelper.compileEPL(eplStatement, eplStatement, true, statementName, this.services, this.defaultStreamSelector);
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null, optionalStatementId, null);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    @Override
    public EPStatement create(EPStatementObjectModel sodaStatement) throws EPException {
        return this.create(sodaStatement, null);
    }

    @Override
    public EPStatement createModelStatementId(EPStatementObjectModel sodaStatement, String statementName, Object userObject, int statementId) throws EPException {
        return this.create(sodaStatement, statementName, userObject, (Integer)statementId);
    }

    @Override
    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName, Object userObject) throws EPException {
        return this.create(sodaStatement, statementName, userObject, null);
    }

    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName, Object userObject, Integer optionalStatementId) throws EPException {
        StatementSpecRaw statementSpec = this.mapSODAToRaw(sodaStatement);
        String eplStatement = sodaStatement.toEPL();
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null, optionalStatementId, sodaStatement);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    @Override
    public EPStatement create(EPStatementObjectModel sodaStatement, String statementName) throws EPException {
        StatementSpecRaw statementSpec = this.mapSODAToRaw(sodaStatement);
        String eplStatement = sodaStatement.toEPL();
        EPStatement statement = this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, null, null, null, sodaStatement);
        log.debug(".createEPLStmt Statement created and started");
        return statement;
    }

    @Override
    public EPPreparedStatement prepareEPL(String eplExpression) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorHelper.compileEPL(eplExpression, eplExpression, true, null, this.services, this.defaultStreamSelector);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getSubstitutionParams(), eplExpression);
    }

    @Override
    public EPPreparedStatement preparePattern(String patternExpression) throws EPException {
        StatementSpecRaw rawPattern = EPAdministratorHelper.compilePattern(patternExpression, patternExpression, true, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(rawPattern);
        return new EPPreparedStatementImpl(unmapped.getObjectModel(), unmapped.getSubstitutionParams(), null);
    }

    public EPStatement create(EPPreparedStatement prepared, String statementName, Object userObject, Integer optionalStatementId) throws EPException {
        EPPreparedStatementImpl impl = (EPPreparedStatementImpl)prepared;
        StatementSpecRaw statementSpec = this.mapSODAToRaw(impl.getModel());
        String eplStatement = impl.getModel().toEPL();
        return this.services.getStatementLifecycleSvc().createAndStart(statementSpec, eplStatement, false, statementName, userObject, null, optionalStatementId, impl.getModel());
    }

    @Override
    public EPStatement create(EPPreparedStatement prepared, String statementName) throws EPException {
        return this.create(prepared, statementName, null, null);
    }

    @Override
    public EPStatement create(EPPreparedStatement prepared, String statementName, Object userObject) throws EPException {
        return this.create(prepared, statementName, userObject, null);
    }

    @Override
    public EPStatement createPreparedEPLStatementId(EPPreparedStatementImpl prepared, String statementName, Object userObject, int statementId) throws EPException {
        return this.create(prepared, statementName, userObject, (Integer)statementId);
    }

    @Override
    public EPStatement create(EPPreparedStatement prepared) throws EPException {
        return this.create(prepared, null);
    }

    @Override
    public EPStatementObjectModel compileEPL(String eplStatement) throws EPException {
        StatementSpecRaw statementSpec = EPAdministratorHelper.compileEPL(eplStatement, eplStatement, true, null, this.services, this.defaultStreamSelector);
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(statementSpec);
        if (unmapped.getSubstitutionParams().size() != 0) {
            throw new EPException(SUBS_PARAM_INVALID_USE);
        }
        return unmapped.getObjectModel();
    }

    @Override
    public EPStatement getStatement(String name) {
        return this.services.getStatementLifecycleSvc().getStatementByName(name);
    }

    @Override
    public String getStatementNameForId(int statementId) {
        return this.services.getStatementLifecycleSvc().getStatementNameById(statementId);
    }

    @Override
    public String[] getStatementNames() {
        return this.services.getStatementLifecycleSvc().getStatementNames();
    }

    @Override
    public void startAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().startAllStatements();
    }

    @Override
    public void stopAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().stopAllStatements();
    }

    @Override
    public void destroyAllStatements() throws EPException {
        this.services.getStatementLifecycleSvc().destroyAllStatements();
    }

    @Override
    public ConfigurationOperations getConfiguration() {
        return this.configurationOperations;
    }

    @Override
    public void destroy() {
        this.services = null;
        this.configurationOperations = null;
    }

    @Override
    public StatementSpecRaw compileEPLToRaw(String epl) {
        return EPAdministratorHelper.compileEPL(epl, epl, true, null, this.services, this.defaultStreamSelector);
    }

    @Override
    public EPStatementObjectModel mapRawToSODA(StatementSpecRaw raw) {
        StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(raw);
        if (unmapped.getSubstitutionParams().size() != 0) {
            throw new EPException(SUBS_PARAM_INVALID_USE);
        }
        return unmapped.getObjectModel();
    }

    @Override
    public StatementSpecRaw mapSODAToRaw(EPStatementObjectModel model) {
        return StatementSpecMapper.map(model, this.services.getEngineImportService(), this.services.getVariableService(), this.services.getConfigSnapshot(), this.services.getSchedulingService(), this.services.getEngineURI(), this.services.getPatternNodeFactory(), this.services.getNamedWindowMgmtService(), this.services.getContextManagementService(), this.services.getExprDeclaredService(), this.services.getTableService());
    }

    @Override
    public EvalFactoryNode compilePatternToNode(String pattern) throws EPException {
        StatementSpecRaw raw = EPAdministratorHelper.compilePattern(pattern, pattern, false, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return ((PatternStreamSpecRaw)raw.getStreamSpecs().get(0)).getEvalFactoryNode();
    }

    @Override
    public EPStatementObjectModel compilePatternToSODAModel(String expression) throws EPException {
        StatementSpecRaw rawPattern = EPAdministratorHelper.compilePattern(expression, expression, true, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return this.mapRawToSODA(rawPattern);
    }

    @Override
    public ExprNode compileExpression(String expression) throws EPException {
        String toCompile = "select * from java.lang.Object#time(" + expression + ")";
        StatementSpecRaw raw = EPAdministratorHelper.compileEPL(toCompile, expression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return raw.getStreamSpecs().get(0).getViewSpecs()[0].getObjectParameters().get(0);
    }

    @Override
    public Expression compileExpressionToSODA(String expression) throws EPException {
        ExprNode node = this.compileExpression(expression);
        return StatementSpecMapper.unmap(node);
    }

    @Override
    public PatternExpr compilePatternToSODA(String expression) throws EPException {
        EvalFactoryNode node = this.compilePatternToNode(expression);
        return StatementSpecMapper.unmap(node);
    }

    @Override
    public AnnotationPart compileAnnotationToSODA(String annotationExpression) {
        String toCompile = annotationExpression + " select * from java.lang.Object";
        StatementSpecRaw raw = EPAdministratorHelper.compileEPL(toCompile, annotationExpression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return StatementSpecMapper.unmap(raw.getAnnotations().get(0));
    }

    @Override
    public MatchRecognizeRegEx compileMatchRecognizePatternToSODA(String matchRecogPatternExpression) {
        String toCompile = "select * from java.lang.Object match_recognize(measures a.b as c pattern (" + matchRecogPatternExpression + ") define A as true)";
        StatementSpecRaw raw = EPAdministratorHelper.compileEPL(toCompile, matchRecogPatternExpression, false, null, this.services, SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        return StatementSpecMapper.unmap(raw.getMatchRecognizeSpec().getPattern());
    }

    @Override
    public EPContextPartitionAdmin getContextPartitionAdmin() {
        return new EPContextPartitionAdminImpl(this.services);
    }
}

