/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPOnDemandPreparedQueryParameterized;
import com.espertech.esper.client.EPPreparedStatement;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.epl.spec.SubstitutionParameterExpressionBase;
import com.espertech.esper.epl.spec.SubstitutionParameterExpressionIndexed;
import com.espertech.esper.epl.spec.SubstitutionParameterExpressionNamed;
import java.io.Serializable;
import java.util.List;

public class EPPreparedStatementImpl
implements EPPreparedStatement,
EPOnDemandPreparedQueryParameterized,
Serializable {
    private static final long serialVersionUID = 821297634350548600L;
    private final EPStatementObjectModel model;
    private final List<SubstitutionParameterExpressionBase> subParams;
    private final String optionalEPL;
    private boolean initialized;

    public EPPreparedStatementImpl(EPStatementObjectModel model, List<SubstitutionParameterExpressionBase> subParams, String optionalEPL) {
        this.model = model;
        this.subParams = subParams;
        this.optionalEPL = optionalEPL;
    }

    @Override
    public void setObject(String parameterName, Object value) throws EPException {
        this.validateNonEmpty();
        if (this.subParams.get(0) instanceof SubstitutionParameterExpressionIndexed) {
            throw new IllegalArgumentException("Substitution parameters are unnamed, please use setObject(index,...) instead");
        }
        boolean found = false;
        for (SubstitutionParameterExpressionBase subs : this.subParams) {
            if (!((SubstitutionParameterExpressionNamed)subs).getName().equals(parameterName)) continue;
            found = true;
            subs.setConstant(value);
        }
        if (!found) {
            throw new IllegalArgumentException("Invalid substitution parameter name of '" + parameterName + "' supplied, failed to find the name");
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws EPException {
        this.validateNonEmpty();
        if (this.subParams.get(0) instanceof SubstitutionParameterExpressionNamed) {
            throw new IllegalArgumentException("Substitution parameters are named, please use setObject(name,...) instead");
        }
        if (parameterIndex < 1) {
            throw new IllegalArgumentException("Substitution parameter index starts at 1");
        }
        boolean found = false;
        for (SubstitutionParameterExpressionBase subs : this.subParams) {
            if (((SubstitutionParameterExpressionIndexed)subs).getIndex() != parameterIndex) continue;
            found = true;
            subs.setConstant(value);
        }
        if (!found) {
            throw new IllegalArgumentException("Invalid substitution parameter index of " + parameterIndex + " supplied, the maximum for this statement is " + this.subParams.size());
        }
    }

    public EPStatementObjectModel getModel() {
        return this.model;
    }

    public String getOptionalEPL() {
        return this.optionalEPL;
    }

    private void validateNonEmpty() {
        if (this.subParams.size() == 0) {
            throw new IllegalArgumentException("Statement does not have substitution parameters indicated by the '?' character");
        }
    }
}

