/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.core.service.ExpressionResultCacheForEnumerationMethod;
import com.espertech.esper.core.service.ExpressionResultCacheStackEntry;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class ExpressionResultCacheForEnumerationMethodImpl
implements ExpressionResultCacheForEnumerationMethod {
    private final IdentityHashMap<Object, SoftReference<ExpressionResultCacheEntry<Long[], Object>>> enumMethodCache = new IdentityHashMap();
    private Deque<ExpressionResultCacheStackEntry> callStack;
    private Deque<Long> lastValueCacheStack;

    @Override
    public void pushStack(ExpressionResultCacheStackEntry lambda) {
        if (this.callStack == null) {
            this.callStack = new ArrayDeque<ExpressionResultCacheStackEntry>();
            this.lastValueCacheStack = new ArrayDeque<Long>(10);
        }
        this.callStack.push(lambda);
    }

    @Override
    public boolean popLambda() {
        this.callStack.remove();
        return this.callStack.isEmpty();
    }

    @Override
    public Deque<ExpressionResultCacheStackEntry> getStack() {
        return this.callStack;
    }

    @Override
    public ExpressionResultCacheEntry<Long[], Object> getEnumerationMethodLastValue(Object node) {
        SoftReference<ExpressionResultCacheEntry<Long[], Object>> cacheRef = this.enumMethodCache.get(node);
        if (cacheRef == null) {
            return null;
        }
        ExpressionResultCacheEntry<Long[], Object> entry = cacheRef.get();
        if (entry == null) {
            return null;
        }
        Long[] required = entry.getReference();
        if (required.length != this.lastValueCacheStack.size()) {
            return null;
        }
        Iterator<Long> prov = this.lastValueCacheStack.iterator();
        for (int i = 0; i < this.lastValueCacheStack.size(); ++i) {
            if (required[i].equals(prov.next())) continue;
            return null;
        }
        return entry;
    }

    @Override
    public void saveEnumerationMethodLastValue(Object node, Object result) {
        Long[] snapshot = this.lastValueCacheStack.toArray(new Long[this.lastValueCacheStack.size()]);
        ExpressionResultCacheEntry<Long[], Object> entry = new ExpressionResultCacheEntry<Long[], Object>(snapshot, result);
        this.enumMethodCache.put(node, new SoftReference<ExpressionResultCacheEntry<Long[], Object>>(entry));
    }

    @Override
    public void pushContext(long contextNumber) {
        if (this.callStack == null) {
            this.callStack = new ArrayDeque<ExpressionResultCacheStackEntry>();
            this.lastValueCacheStack = new ArrayDeque<Long>(10);
        }
        this.lastValueCacheStack.push(contextNumber);
    }

    @Override
    public void popContext() {
        this.lastValueCacheStack.remove();
    }
}

