/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.dispatch.Dispatchable;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternListenerDispatch
implements Dispatchable {
    private static Logger log = LoggerFactory.getLogger(PatternListenerDispatch.class);
    private final Set<UpdateListener> listeners;
    private EventBean singleEvent;
    private ArrayList<EventBean> eventList;

    public PatternListenerDispatch(Set<UpdateListener> listeners) {
        this.listeners = listeners;
    }

    public void add(EventBean theEvent) {
        if (this.singleEvent == null) {
            this.singleEvent = theEvent;
        } else {
            if (this.eventList == null) {
                this.eventList = new ArrayList(5);
                this.eventList.add(this.singleEvent);
            }
            this.eventList.add(theEvent);
        }
    }

    @Override
    public void execute() {
        EventBean[] eventArray;
        if (this.eventList != null) {
            eventArray = this.eventList.toArray(new EventBean[this.eventList.size()]);
            this.eventList = null;
            this.singleEvent = null;
        } else {
            eventArray = new EventBean[]{this.singleEvent};
            this.singleEvent = null;
        }
        for (UpdateListener listener : this.listeners) {
            try {
                listener.update(eventArray, null);
            }
            catch (Throwable t) {
                String message = "Unexpected exception invoking listener update method on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                log.error(message, t);
            }
        }
    }

    public boolean hasData() {
        return this.singleEvent != null;
    }
}

