/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.DeliveryConvertor;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultDeliveryStrategyImpl
implements ResultDeliveryStrategy {
    private static Logger log = LoggerFactory.getLogger(ResultDeliveryStrategyImpl.class);
    private final EPStatement statement;
    private final Object subscriber;
    private final FastMethod updateMethodFast;
    private final FastMethod startMethodFast;
    private final boolean startMethodHasEPStatement;
    private final FastMethod endMethodFast;
    private final boolean endMethodHasEPStatement;
    private final FastMethod updateRStreamMethodFast;
    private final DeliveryConvertor deliveryConvertor;

    public ResultDeliveryStrategyImpl(EPStatement statement, Object subscriber, DeliveryConvertor deliveryConvertor, Method method, Method startMethod, Method endMethod, Method rStreamMethod, EngineImportService engineImportService) {
        this.statement = statement;
        this.subscriber = subscriber;
        this.deliveryConvertor = deliveryConvertor;
        FastClass fastClass = FastClass.create((ClassLoader)engineImportService.getFastClassClassLoader(subscriber.getClass()), subscriber.getClass());
        this.updateMethodFast = fastClass.getMethod(method);
        if (startMethod != null) {
            this.startMethodFast = fastClass.getMethod(startMethod);
            this.startMethodHasEPStatement = ResultDeliveryStrategyImpl.isMethodAcceptsStatement(startMethod);
        } else {
            this.startMethodFast = null;
            this.startMethodHasEPStatement = false;
        }
        if (endMethod != null) {
            this.endMethodFast = fastClass.getMethod(endMethod);
            this.endMethodHasEPStatement = ResultDeliveryStrategyImpl.isMethodAcceptsStatement(endMethod);
        } else {
            this.endMethodFast = null;
            this.endMethodHasEPStatement = false;
        }
        this.updateRStreamMethodFast = rStreamMethod != null ? fastClass.getMethod(rStreamMethod) : null;
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[] parameters;
        NaturalEventBean natural;
        EventBean theEvent;
        if (this.startMethodFast != null) {
            int countNew = 0;
            int countOld = 0;
            if (result != null) {
                countNew = this.count(result.getFirst());
                countOld = this.count(result.getSecond());
            }
            Object[] parameters2 = !this.startMethodHasEPStatement ? new Object[]{countNew, countOld} : new Object[]{this.statement, countNew, countOld};
            try {
                this.startMethodFast.invoke(this.subscriber, parameters2);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, parameters2, this.subscriber, this.startMethodFast);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.startMethodFast);
            }
        }
        EventBean[] newData = null;
        EventBean[] oldData = null;
        if (result != null) {
            newData = result.getFirst();
            oldData = result.getSecond();
        }
        if (newData != null && newData.length > 0) {
            for (int i = 0; i < newData.length; ++i) {
                theEvent = newData[i];
                if (!(theEvent instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)theEvent;
                parameters = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateMethodFast.invoke(this.subscriber, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, parameters, this.subscriber, this.updateMethodFast);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, parameters, this.subscriber, this.updateMethodFast);
                }
            }
        }
        if (this.updateRStreamMethodFast != null && oldData != null && oldData.length > 0) {
            for (int i = 0; i < oldData.length; ++i) {
                theEvent = oldData[i];
                if (!(theEvent instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)theEvent;
                parameters = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateRStreamMethodFast.invoke(this.subscriber, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, parameters, this.subscriber, this.updateRStreamMethodFast);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, parameters, this.subscriber, this.updateRStreamMethodFast);
                }
            }
        }
        if (this.endMethodFast != null) {
            Object[] objectArray;
            if (this.endMethodHasEPStatement) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.statement;
            } else {
                objectArray = null;
            }
            Object[] parameters3 = objectArray;
            try {
                this.endMethodFast.invoke(this.subscriber, parameters3);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statement.getName(), log, e, null, this.subscriber, this.endMethodFast);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.endMethodFast);
            }
        }
    }

    protected static void handle(String statementName, Logger logger, InvocationTargetException e, Object[] parameters, Object subscriber, FastMethod method) {
        String message = JavaClassHelper.getMessageInvocationTarget(statementName, method.getJavaMethod(), subscriber.getClass().getName(), parameters, e);
        logger.error(message, e.getTargetException());
    }

    protected static void handleThrowable(Logger logger, Throwable t, Object[] parameters, Object subscriber, FastMethod method) {
        String message = "Unexpected exception when invoking method '" + method.getName() + "' on subscriber class '" + subscriber.getClass().getSimpleName() + "' for parameters " + (parameters == null ? "null" : Arrays.toString(parameters)) + " : " + t.getClass().getSimpleName() + " : " + t.getMessage();
        logger.error(message, t);
    }

    private int count(EventBean[] events) {
        if (events == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < events.length; ++i) {
            EventBean theEvent = events[i];
            if (!(theEvent instanceof NaturalEventBean)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isMethodAcceptsStatement(Method method) {
        return method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == EPStatement.class;
    }
}

