/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatementStateListener;
import com.espertech.esper.core.service.StatementLifecycleEvent;
import com.espertech.esper.core.service.StatementLifecycleObserver;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementEventDispatcherUnthreaded
implements StatementLifecycleObserver {
    private static Logger log = LoggerFactory.getLogger(StatementEventDispatcherUnthreaded.class);
    private final EPServiceProvider serviceProvider;
    private final Iterable<EPStatementStateListener> statementListeners;

    public StatementEventDispatcherUnthreaded(EPServiceProvider serviceProvider, Iterable<EPStatementStateListener> statementListeners) {
        this.serviceProvider = serviceProvider;
        this.statementListeners = statementListeners;
    }

    @Override
    public void observe(StatementLifecycleEvent theEvent) {
        block7: {
            block6: {
                if (theEvent.getEventType() != StatementLifecycleEvent.LifecycleEventType.CREATE) break block6;
                Iterator<EPStatementStateListener> it = this.statementListeners.iterator();
                while (it.hasNext()) {
                    try {
                        it.next().onStatementCreate(this.serviceProvider, theEvent.getStatement());
                    }
                    catch (RuntimeException ex) {
                        log.error("Caught runtime exception in onStatementCreate callback:" + ex.getMessage(), (Throwable)ex);
                    }
                }
                break block7;
            }
            if (theEvent.getEventType() != StatementLifecycleEvent.LifecycleEventType.STATECHANGE) break block7;
            Iterator<EPStatementStateListener> it = this.statementListeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().onStatementStateChange(this.serviceProvider, theEvent.getStatement());
                }
                catch (RuntimeException ex) {
                    log.error("Caught runtime exception in onStatementCreate callback:" + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

