/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.util.DestroyCallback;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPStatementDestroyCallbackList
implements EPStatementDestroyMethod {
    private static final Logger log = LoggerFactory.getLogger(EPStatementDestroyCallbackList.class);
    private Deque<DestroyCallback> callbacks;

    public void addCallback(DestroyCallback destroyCallback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayDeque<DestroyCallback>(2);
        }
        this.callbacks.add(destroyCallback);
    }

    @Override
    public void destroy() {
        if (this.callbacks == null) {
            return;
        }
        for (DestroyCallback destroyCallback : this.callbacks) {
            try {
                destroyCallback.destroy();
            }
            catch (RuntimeException ex) {
                log.error("Failed to destroy resource: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

