/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.client.annotation.IterableUnbound;
import com.espertech.esper.client.hook.SQLColumnTypeConversion;
import com.espertech.esper.client.hook.SQLOutputRowConversion;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.activator.ViewableActivatorFactory;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelect;
import com.espertech.esper.core.context.subselect.SubSelectActivationCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.core.start.EPStatementDestroyCallbackList;
import com.espertech.esper.core.start.EPStatementDestroyCallbackTableIdxRef;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperUtil;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.EPStatementStartMethodHelperViewResources;
import com.espertech.esper.core.start.EPStatementStartMethodSelectDesc;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.MethodPollingViewableFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.SelectExprProcessorDeliveryCallback;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.core.ViewResourceDelegateVerified;
import com.espertech.esper.epl.db.DatabasePollingViewableFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.view.OutputProcessViewCallback;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactoryFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.epl.virtualdw.VirtualDWViewProviderForAgentInstance;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.metrics.instrumentation.InstrumentationAgent;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.rowregex.EventRowRegexNFAViewFactory;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.ViewFactoryChain;
import java.util.LinkedList;

public class EPStatementStartMethodSelectUtil {
    public static EPStatementStartMethodSelectDesc prepare(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext, boolean recoveringResilient, AgentInstanceContext defaultAgentInstanceContext, boolean queryPlanLogging, ViewableActivatorFactory optionalViewableActivatorFactory, OutputProcessViewCallback optionalOutputProcessViewCallback, SelectExprProcessorDeliveryCallback selectExprProcessorDeliveryCallback) throws ExprValidationException {
        LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        EPStatementDestroyCallbackList destroyCallbacks = new EPStatementDestroyCallbackList();
        String contextName = statementSpec.getOptionalContextName();
        ContextPropertyRegistry contextPropertyRegistry = contextName != null ? services.getContextManagementService().getContextDescriptor(contextName).getContextPropertyRegistry() : null;
        String[] streamNames = EPStatementStartMethodHelperUtil.determineStreamNames(statementSpec.getStreamSpecs());
        int numStreams = streamNames.length;
        if (numStreams == 0) {
            throw new ExprValidationException("The from-clause is required but has not been specified");
        }
        boolean isJoin = statementSpec.getStreamSpecs().length > 1;
        boolean hasContext = statementSpec.getOptionalContextName() != null;
        SubSelectActivationCollection subSelectStreamDesc = EPStatementStartMethodHelperSubselect.createSubSelectActivation(services, statementSpec, statementContext, destroyCallbacks);
        ViewableActivator[] eventStreamParentViewableActivators = new ViewableActivator[numStreams];
        ViewFactoryChain[] unmaterializedViewChain = new ViewFactoryChain[numStreams];
        String[] eventTypeNames = new String[numStreams];
        boolean[] isNamedWindow = new boolean[numStreams];
        HistoricalEventViewable[] historicalEventViewables = new HistoricalEventViewable[numStreams];
        StreamJoinAnalysisResult joinAnalysisResult = EPStatementStartMethodSelectUtil.verifyJoinViews(statementSpec, statementContext.getNamedWindowMgmtService());
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            boolean isCanIterateUnbound;
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            boolean bl = isCanIterateUnbound = streamSpec.getViewSpecs().length == 0 && (services.getConfigSnapshot().getEngineDefaults().getViewResources().isIterableUnbound() || AnnotationUtil.findAnnotation(statementSpec.getAnnotations(), IterableUnbound.class) != null);
            if (streamSpec instanceof FilterStreamSpecCompiled) {
                ViewableActivator activatorDeactivator;
                FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
                eventTypeNames[i] = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
                boolean filterSubselectSameStream = EPStatementStartMethodHelperUtil.determineSubquerySameStream(statementSpec, filterStreamSpec);
                if (optionalViewableActivatorFactory != null) {
                    activatorDeactivator = optionalViewableActivatorFactory.createActivatorSimple(filterStreamSpec);
                    if (activatorDeactivator == null) {
                        throw new IllegalStateException("Viewable activate is null for " + filterStreamSpec.getFilterSpec().getFilterForEventType().getName());
                    }
                } else if (!hasContext) {
                    activatorDeactivator = services.getViewableActivatorFactory().createStreamReuseView(services, statementContext, statementSpec, filterStreamSpec, isJoin, evaluatorContextStmt, filterSubselectSameStream, i, isCanIterateUnbound);
                } else {
                    InstrumentationAgent instrumentationAgentFilter = null;
                    activatorDeactivator = services.getViewableActivatorFactory().createFilterProxy(services, filterStreamSpec.getFilterSpec(), statementSpec.getAnnotations(), false, instrumentationAgentFilter, isCanIterateUnbound, i);
                }
                eventStreamParentViewableActivators[i] = activatorDeactivator;
                EventType resultEventType = filterStreamSpec.getFilterSpec().getResultEventType();
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, resultEventType, streamSpec.getViewSpecs(), streamSpec.getOptions(), statementContext, false, -1);
                continue;
            }
            if (streamSpec instanceof PatternStreamSpecCompiled) {
                ViewableActivator patternActivator;
                PatternStreamSpecCompiled patternStreamSpec = (PatternStreamSpecCompiled)streamSpec;
                boolean usedByChildViews = streamSpec.getViewSpecs().length > 0 || statementSpec.getInsertIntoDesc() != null;
                String patternTypeName = statementContext.getStatementId() + "_pattern_" + i;
                EventType eventType = services.getEventAdapterService().createSemiAnonymousMapType(patternTypeName, patternStreamSpec.getTaggedEventTypes(), patternStreamSpec.getArrayEventTypes(), usedByChildViews);
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, eventType, streamSpec.getViewSpecs(), streamSpec.getOptions(), statementContext, false, -1);
                EvalRootFactoryNode rootFactoryNode = services.getPatternNodeFactory().makeRootNode(patternStreamSpec.getEvalFactoryNode());
                PatternContext patternContext = statementContext.getPatternContextFactory().createContext(statementContext, i, rootFactoryNode, patternStreamSpec.getMatchedEventMapMeta(), true);
                eventStreamParentViewableActivators[i] = patternActivator = services.getViewableActivatorFactory().createPattern(patternContext, rootFactoryNode, eventType, EPStatementStartMethodHelperUtil.isConsumingFilters(patternStreamSpec.getEvalFactoryNode()), patternStreamSpec.isSuppressSameEventMatches(), patternStreamSpec.isDiscardPartialsOnMatch(), isCanIterateUnbound);
                continue;
            }
            if (streamSpec instanceof DBStatementStreamSpec) {
                HistoricalEventViewable historicalEventViewable;
                EPStatementStartMethodSelectUtil.validateNoViews(streamSpec, "Historical data");
                DBStatementStreamSpec sqlStreamSpec = (DBStatementStreamSpec)streamSpec;
                SQLColumnTypeConversion typeConversionHook = (SQLColumnTypeConversion)JavaClassHelper.getAnnotationHook(statementSpec.getAnnotations(), HookType.SQLCOL, SQLColumnTypeConversion.class, statementContext.getEngineImportService());
                SQLOutputRowConversion outputRowConversionHook = (SQLOutputRowConversion)JavaClassHelper.getAnnotationHook(statementSpec.getAnnotations(), HookType.SQLROW, SQLOutputRowConversion.class, statementContext.getEngineImportService());
                EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = defaultAgentInstanceContext.getEpStatementAgentInstanceHandle();
                historicalEventViewables[i] = historicalEventViewable = DatabasePollingViewableFactory.createDBStatementView(statementContext.getStatementId(), i, sqlStreamSpec, services.getDatabaseRefService(), services.getEventAdapterService(), epStatementAgentInstanceHandle, typeConversionHook, outputRowConversionHook, statementContext.getConfigSnapshot().getEngineDefaults().getLogging().isEnableJDBC(), services.getDataCacheFactory(), statementContext);
                unmaterializedViewChain[i] = ViewFactoryChain.fromTypeNoViews(historicalEventViewable.getEventType());
                eventStreamParentViewableActivators[i] = services.getViewableActivatorFactory().makeHistorical(historicalEventViewable);
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof MethodStreamSpec) {
                HistoricalEventViewable historicalEventViewable;
                EPStatementStartMethodSelectUtil.validateNoViews(streamSpec, "Method data");
                MethodStreamSpec methodStreamSpec = (MethodStreamSpec)streamSpec;
                EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = defaultAgentInstanceContext.getEpStatementAgentInstanceHandle();
                historicalEventViewables[i] = historicalEventViewable = MethodPollingViewableFactory.createPollMethodView(i, methodStreamSpec, services.getEventAdapterService(), epStatementAgentInstanceHandle, statementContext.getEngineImportService(), statementContext.getSchedulingService(), statementContext.getScheduleBucket(), evaluatorContextStmt, statementContext.getVariableService(), statementContext.getContextName(), services.getDataCacheFactory(), statementContext);
                unmaterializedViewChain[i] = ViewFactoryChain.fromTypeNoViews(historicalEventViewable.getEventType());
                eventStreamParentViewableActivators[i] = services.getViewableActivatorFactory().makeHistorical(historicalEventViewable);
                stopCallbacks.add(historicalEventViewable);
                continue;
            }
            if (streamSpec instanceof TableQueryStreamSpec) {
                EPStatementStartMethodSelectUtil.validateNoViews(streamSpec, "Table data");
                TableQueryStreamSpec tableStreamSpec = (TableQueryStreamSpec)streamSpec;
                if (isJoin && tableStreamSpec.getFilterExpressions().size() > 0) {
                    throw new ExprValidationException("Joins with tables do not allow table filter expressions, please add table filters to the where-clause instead");
                }
                TableMetadata metadata = services.getTableService().getTableMetadata(tableStreamSpec.getTableName());
                ExprEvaluator[] tableFilterEvals = null;
                if (tableStreamSpec.getFilterExpressions().size() > 0) {
                    tableFilterEvals = ExprNodeUtility.getEvaluators(tableStreamSpec.getFilterExpressions());
                }
                EPLValidationUtil.validateContextName(true, metadata.getTableName(), metadata.getContextName(), statementSpec.getOptionalContextName(), false);
                eventStreamParentViewableActivators[i] = services.getViewableActivatorFactory().createTable(metadata, tableFilterEvals);
                unmaterializedViewChain[i] = ViewFactoryChain.fromTypeNoViews(metadata.getInternalEventType());
                eventTypeNames[i] = tableStreamSpec.getTableName();
                joinAnalysisResult.setTablesForStream(i, metadata);
                if (tableStreamSpec.getOptions().isUnidirectional()) {
                    throw new ExprValidationException("Tables cannot be marked as unidirectional");
                }
                if (tableStreamSpec.getOptions().isRetainIntersection() || tableStreamSpec.getOptions().isRetainUnion()) {
                    throw new ExprValidationException("Tables cannot be marked with retain");
                }
                if (isJoin) {
                    destroyCallbacks.addCallback(new EPStatementDestroyCallbackTableIdxRef(services.getTableService(), metadata, statementContext.getStatementName()));
                }
                services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), metadata.getTableName());
                continue;
            }
            if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
                NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
                NamedWindowProcessor processor = services.getNamedWindowMgmtService().getProcessor(namedSpec.getWindowName());
                EventType namedWindowType = processor.getTailView().getEventType();
                if (namedSpec.getOptPropertyEvaluator() != null) {
                    namedWindowType = namedSpec.getOptPropertyEvaluator().getFragmentEventType();
                }
                eventStreamParentViewableActivators[i] = services.getViewableActivatorFactory().createNamedWindow(processor, namedSpec, statementContext);
                services.getNamedWindowConsumerMgmtService().addConsumer(statementContext, namedSpec);
                unmaterializedViewChain[i] = services.getViewService().createFactories(i, namedWindowType, namedSpec.getViewSpecs(), namedSpec.getOptions(), statementContext, false, -1);
                joinAnalysisResult.setNamedWindow(i);
                eventTypeNames[i] = namedSpec.getWindowName();
                isNamedWindow[i] = true;
                EPStatementStartMethodHelperValidate.validateNoDataWindowOnNamedWindow(unmaterializedViewChain[i].getViewFactoryChain());
                continue;
            }
            throw new ExprValidationException("Unknown stream specification type: " + streamSpec);
        }
        if (statementSpec.getMatchRecognizeSpec() != null) {
            if (isJoin) {
                throw new ExprValidationException("Joins are not allowed when using match-recognize");
            }
            if (joinAnalysisResult.getTablesPerStream()[0] != null) {
                throw new ExprValidationException("Tables cannot be used with match-recognize");
            }
            boolean isUnbound = unmaterializedViewChain[0].getViewFactoryChain().isEmpty() && !(statementSpec.getStreamSpecs()[0] instanceof NamedWindowConsumerStreamSpec);
            EventRowRegexNFAViewFactory factory = services.getRegexHandlerFactory().makeViewFactory(unmaterializedViewChain[0], statementSpec.getMatchRecognizeSpec(), defaultAgentInstanceContext, isUnbound, statementSpec.getAnnotations(), services.getConfigSnapshot().getEngineDefaults().getMatchRecognize());
            unmaterializedViewChain[0].getViewFactoryChain().add(factory);
            EPStatementStartMethodHelperAssignExpr.assignAggregations(factory.getAggregationService(), factory.getAggregationExpressions());
        }
        EventType[] streamEventTypes = new EventType[statementSpec.getStreamSpecs().length];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            streamEventTypes[i] = unmaterializedViewChain[i].getEventType();
        }
        joinAnalysisResult.addUniquenessInfo(unmaterializedViewChain, statementSpec.getAnnotations());
        SubSelectStrategyCollection subSelectStrategyCollection = EPStatementStartMethodHelperSubselect.planSubSelect(services, statementContext, queryPlanLogging, subSelectStreamDesc, streamNames, streamEventTypes, eventTypeNames, statementSpec.getDeclaredExpressions(), contextPropertyRegistry);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(streamEventTypes, streamNames, EPStatementStartMethodHelperUtil.getHasIStreamOnly(isNamedWindow, unmaterializedViewChain), services.getEngineURI(), false);
        ViewResourceDelegateUnverified viewResourceDelegateUnverified = new ViewResourceDelegateUnverified();
        HistoricalViewableDesc historicalViewableDesc = new HistoricalViewableDesc(numStreams);
        for (int stream = 0; stream < historicalEventViewables.length; ++stream) {
            HistoricalEventViewable historicalEventViewable = historicalEventViewables[stream];
            if (historicalEventViewable == null) continue;
            historicalEventViewable.validate(services.getEngineImportService(), typeService, statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, services.getConfigSnapshot(), services.getSchedulingService(), services.getEngineURI(), statementSpec.getSqlParameters(), statementContext.getEventAdapterService(), statementContext);
            historicalViewableDesc.setHistorical(stream, historicalEventViewable.getRequiredStreams());
            if (!historicalEventViewable.getRequiredStreams().contains(stream)) continue;
            throw new ExprValidationException("Parameters for historical stream " + stream + " indicate that the stream is subordinate to itself as stream parameters originate in the same stream");
        }
        if (joinAnalysisResult.isUnidirectional() && statementSpec.getIntoTableSpec() != null) {
            throw new ExprValidationException("Into-table does not allow unidirectional joins");
        }
        ResultSetProcessorFactoryDesc resultSetProcessorPrototypeDesc = ResultSetProcessorFactoryFactory.getProcessorPrototype(statementSpec, statementContext, typeService, viewResourceDelegateUnverified, joinAnalysisResult.getUnidirectionalInd(), true, contextPropertyRegistry, selectExprProcessorDeliveryCallback, services.getConfigSnapshot(), services.getResultSetProcessorHelperFactory(), false, false);
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, viewResourceDelegateUnverified);
        ViewResourceDelegateVerified viewResourceDelegateVerified = EPStatementStartMethodHelperViewResources.verifyPreviousAndPriorRequirements(unmaterializedViewChain, viewResourceDelegateUnverified);
        JoinSetComposerPrototype joinSetComposerPrototype = null;
        if (numStreams > 1) {
            boolean selectsRemoveStream = statementSpec.getSelectStreamSelectorEnum().isSelectsRStream() || statementSpec.getOutputLimitSpec() != null;
            boolean hasAggregations = !resultSetProcessorPrototypeDesc.getAggregationServiceFactoryDesc().getExpressions().isEmpty();
            joinSetComposerPrototype = JoinSetComposerPrototypeFactory.makeComposerPrototype(statementContext.getStatementName(), statementContext.getStatementId(), statementSpec.getOuterJoinDescList(), statementSpec.getFilterRootNode(), typeService.getEventTypes(), streamNames, joinAnalysisResult, queryPlanLogging, statementContext, historicalViewableDesc, defaultAgentInstanceContext, selectsRemoveStream, hasAggregations, services.getTableService(), false, services.getEventTableIndexService().allowInitIndex(recoveringResilient));
        }
        OutputProcessViewFactory outputViewFactory = OutputProcessViewFactoryFactory.make(statementSpec, services.getInternalEventRouter(), statementContext, resultSetProcessorPrototypeDesc.getResultSetProcessorFactory().getResultEventType(), optionalOutputProcessViewCallback, services.getTableService(), resultSetProcessorPrototypeDesc.getResultSetProcessorFactory().getResultSetProcessorType(), services.getResultSetProcessorHelperFactory(), services.getStatementVariableRefService());
        StatementAgentInstanceFactorySelect factory = new StatementAgentInstanceFactorySelect(numStreams, eventStreamParentViewableActivators, statementContext, statementSpec, services, typeService, unmaterializedViewChain, resultSetProcessorPrototypeDesc, joinAnalysisResult, recoveringResilient, joinSetComposerPrototype, subSelectStrategyCollection, viewResourceDelegateVerified, outputViewFactory);
        EPStatementStopMethodImpl stopMethod = new EPStatementStopMethodImpl(statementContext, stopCallbacks);
        return new EPStatementStartMethodSelectDesc(factory, subSelectStrategyCollection, viewResourceDelegateUnverified, resultSetProcessorPrototypeDesc, stopMethod, destroyCallbacks);
    }

    private static void validateNoViews(StreamSpecCompiled streamSpec, String conceptName) throws ExprValidationException {
        if (streamSpec.getViewSpecs().length > 0) {
            throw new ExprValidationException(conceptName + " joins do not allow views onto the data, view '" + streamSpec.getViewSpecs()[0].getObjectName() + "' is not valid in this context");
        }
    }

    private static StreamJoinAnalysisResult verifyJoinViews(StatementSpecCompiled statementSpec, NamedWindowMgmtService namedWindowMgmtService) throws ExprValidationException {
        StreamSpecCompiled[] streamSpecs = statementSpec.getStreamSpecs();
        StreamJoinAnalysisResult analysisResult = new StreamJoinAnalysisResult(streamSpecs.length);
        if (streamSpecs.length < 2) {
            return analysisResult;
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getOptions().isUnidirectional()) {
                analysisResult.setUnidirectionalInd(i);
            }
            if (streamSpec.getViewSpecs().length > 0) {
                analysisResult.setHasChildViews(i);
            }
            if (!(streamSpec instanceof NamedWindowConsumerStreamSpec)) continue;
            NamedWindowConsumerStreamSpec nwSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            if (nwSpec.getOptPropertyEvaluator() != null && !streamSpec.getOptions().isUnidirectional()) {
                throw new ExprValidationException("Failed to validate named window use in join, contained-event is only allowed for named windows when marked as unidirectional");
            }
            analysisResult.setNamedWindow(i);
            final NamedWindowProcessor processor = namedWindowMgmtService.getProcessor(nwSpec.getWindowName());
            StreamSpecCompiled[] uniqueIndexes = processor.getUniqueIndexes();
            analysisResult.getUniqueKeys()[i] = uniqueIndexes;
            if (!processor.isVirtualDataWindow()) continue;
            analysisResult.getViewExternal()[i] = new VirtualDWViewProviderForAgentInstance(){

                @Override
                public VirtualDWView getView(AgentInstanceContext agentInstanceContext) {
                    return processor.getProcessorInstance(agentInstanceContext).getRootViewInstance().getVirtualDataWindow();
                }
            };
        }
        if (statementSpec.getStreamSpecs().length > 1 && analysisResult.isUnidirectional()) {
            EPStatementStartMethodSelectUtil.verifyJoinUnidirectional(analysisResult, statementSpec);
        }
        int countProviderNonpolling = 0;
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec instanceof MethodStreamSpec || streamSpec instanceof DBStatementStreamSpec || streamSpec instanceof TableQueryStreamSpec) continue;
            ++countProviderNonpolling;
        }
        if (countProviderNonpolling == 1) {
            return analysisResult;
        }
        FilterSpecCompiled unidirectionalFilterSpec = null;
        FilterSpecCompiled lastFilterSpec = null;
        boolean pureSelfJoin = true;
        for (StreamSpecCompiled streamSpec : statementSpec.getStreamSpecs()) {
            if (!(streamSpec instanceof FilterStreamSpecCompiled)) {
                pureSelfJoin = false;
                continue;
            }
            FilterSpecCompiled filterSpec = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec();
            if (lastFilterSpec != null && !lastFilterSpec.equalsTypeAndFilter(filterSpec)) {
                pureSelfJoin = false;
            }
            if (streamSpec.getViewSpecs().length > 0) {
                pureSelfJoin = false;
            }
            lastFilterSpec = filterSpec;
            if (!streamSpec.getOptions().isUnidirectional()) continue;
            unidirectionalFilterSpec = filterSpec;
        }
        if (pureSelfJoin && unidirectionalFilterSpec == null) {
            analysisResult.setPureSelfJoin(true);
            return analysisResult;
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[i];
            if (streamSpec.getViewSpecs().length > 0) continue;
            String name = streamSpec.getOptionalStreamName();
            if (name == null && streamSpec instanceof FilterStreamSpecCompiled) {
                name = ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventTypeName();
            }
            if (name == null && streamSpec instanceof PatternStreamSpecCompiled) {
                name = "pattern event stream";
            }
            if (streamSpec.getOptions().isUnidirectional()) continue;
            if (unidirectionalFilterSpec != null && streamSpec instanceof FilterStreamSpecCompiled && ((FilterStreamSpecCompiled)streamSpec).getFilterSpec().equalsTypeAndFilter(unidirectionalFilterSpec)) {
                analysisResult.setUnidirectionalNonDriving(i);
                continue;
            }
            if (!(streamSpec instanceof FilterStreamSpecCompiled) && !(streamSpec instanceof PatternStreamSpecCompiled)) continue;
            throw new ExprValidationException("Joins require that at least one view is specified for each stream, no view was specified for " + name);
        }
        return analysisResult;
    }

    private static void verifyJoinUnidirectional(StreamJoinAnalysisResult analysisResult, StatementSpecCompiled statementSpec) throws ExprValidationException {
        int numUnidirectionalStreams = analysisResult.getUnidirectionalCount();
        int numStreams = statementSpec.getStreamSpecs().length;
        if (!EPStatementStartMethodSelectUtil.isFullOuterJoinAllStreams(statementSpec)) {
            if (numUnidirectionalStreams > 1) {
                throw new ExprValidationException("The unidirectional keyword can only apply to one stream in a join");
            }
        } else if (numUnidirectionalStreams > 1 && numUnidirectionalStreams < numStreams) {
            throw new ExprValidationException("The unidirectional keyword must either apply to a single stream or all streams in a full outer join");
        }
        for (int i = 0; i < statementSpec.getStreamSpecs().length; ++i) {
            if (!analysisResult.getUnidirectionalInd()[i] || !analysisResult.getHasChildViews()[i]) continue;
            throw new ExprValidationException("The unidirectional keyword requires that no views are declared onto the stream (applies to stream " + i + ")");
        }
    }

    private static boolean isFullOuterJoinAllStreams(StatementSpecCompiled statementSpec) {
        if (statementSpec.getOuterJoinDescList() == null || statementSpec.getOuterJoinDescList().length == 0) {
            return false;
        }
        for (int stream = 0; stream < statementSpec.getStreamSpecs().length - 1; ++stream) {
            if (statementSpec.getOuterJoinDescList()[stream].getOuterJoinType() == OuterJoinType.FULL) continue;
            return false;
        }
        return true;
    }
}

