/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdate;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdateResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementOnTriggerDesc;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.stmt.AIRegistrySubselect;
import com.espertech.esper.core.context.subselect.SubSelectActivationCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.InternalEventRouterDesc;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.start.EPStatementDestroyCallbackContext;
import com.espertech.esper.core.start.EPStatementDestroyCallbackList;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.HashMap;
import java.util.LinkedList;

public class EPStatementStartMethodUpdate
extends EPStatementStartMethodBase {
    public EPStatementStartMethodUpdate(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(final EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementStopMethod stopStatementMethod;
        Viewable finalViewable;
        HashMap<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategyInstances;
        String triggereventTypeName;
        LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        EPStatementDestroyCallbackList destroyCallbacks = new EPStatementDestroyCallbackList();
        final String contextName = this.statementSpec.getOptionalContextName();
        if (contextName != null) {
            throw new ExprValidationException("Update IStream is not supported in conjunction with a context");
        }
        SubSelectActivationCollection subSelectStreamDesc = EPStatementStartMethodHelperSubselect.createSubSelectActivation(services, this.statementSpec, statementContext, destroyCallbacks);
        StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs()[0];
        UpdateDesc updateSpec = this.statementSpec.getUpdateSpec();
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            triggereventTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            triggereventTypeName = namedSpec.getWindowName();
        } else {
            if (streamSpec instanceof TableQueryStreamSpec) {
                throw new ExprValidationException("Tables cannot be used in an update-istream statement");
            }
            throw new ExprValidationException("Unknown stream specification streamEventType: " + streamSpec);
        }
        String streamName = triggereventTypeName;
        if (updateSpec.getOptionalStreamName() != null) {
            streamName = updateSpec.getOptionalStreamName();
        }
        EventType streamEventType = services.getEventAdapterService().getExistsTypeByName(triggereventTypeName);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamName}, new boolean[]{true}, services.getEngineURI(), false);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        statementContext.getStatementResultService().setSelectClause(new Class[]{streamEventType.getUnderlyingType()}, new String[]{"*"}, false, null, evaluatorContextStmt);
        SubSelectStrategyCollection subSelectStrategyCollection = EPStatementStartMethodHelperSubselect.planSubSelect(services, statementContext, this.isQueryPlanLogging(services), subSelectStreamDesc, new String[]{streamName}, new EventType[]{streamEventType}, new String[]{triggereventTypeName}, this.statementSpec.getDeclaredExpressions(), null);
        ExprValidationContext validationContext = new ExprValidationContext(typeService, statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
        for (OnTriggerSetAssignment assignment : updateSpec.getAssignments()) {
            ExprNode validated = ExprNodeUtility.getValidatedAssignment(assignment, validationContext);
            assignment.setExpression(validated);
            EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        if (updateSpec.getOptionalWhereClause() != null) {
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.WHERE, updateSpec.getOptionalWhereClause(), validationContext);
            updateSpec.setOptionalWhereClause(validated);
            EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        InternalRoutePreprocessView onExprView = new InternalRoutePreprocessView(streamEventType, statementContext.getStatementResultService());
        InternalEventRouterDesc routerDesc = services.getInternalEventRouter().getValidatePreprocessing(onExprView.getEventType(), updateSpec, statementContext.getAnnotations());
        StatementAgentInstanceFactoryUpdate contextFactory = new StatementAgentInstanceFactoryUpdate(statementContext, services, streamEventType, updateSpec, onExprView, routerDesc, subSelectStrategyCollection);
        statementContext.setStatementAgentInstanceFactory(contextFactory);
        final EPStatementStopMethodImpl stopMethod = new EPStatementStopMethodImpl(statementContext, stopCallbacks);
        if (this.statementSpec.getOptionalContextName() != null) {
            AIRegistryExpr aiRegistryExpr = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            subselectStrategyInstances = new HashMap<ExprSubselectNode, SubSelectStrategyHolder>();
            for (ExprSubselectNode node : subSelectStrategyCollection.getSubqueries().keySet()) {
                AIRegistrySubselect specificService = aiRegistryExpr.allocateSubselect(node);
                node.setStrategy(specificService);
                subselectStrategyInstances.put(node, new SubSelectStrategyHolder(null, null, null, null, null, null, null));
            }
            ContextMergeView mergeView = new ContextMergeView(onExprView.getEventType());
            finalViewable = mergeView;
            ContextManagedStatementOnTriggerDesc statement = new ContextManagedStatementOnTriggerDesc(this.statementSpec, statementContext, mergeView, contextFactory);
            services.getContextManagementService().addStatement(this.statementSpec.getOptionalContextName(), statement, isRecoveringResilient);
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    services.getContextManagementService().stoppedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getExpression(), statementContext.getExceptionHandlingService());
                    stopMethod.stop();
                }
            };
            destroyCallbacks.addCallback(new EPStatementDestroyCallbackContext(services.getContextManagementService(), this.statementSpec.getOptionalContextName(), statementContext.getStatementName(), statementContext.getStatementId()));
        } else {
            AgentInstanceContext agentInstanceContext = this.getDefaultAgentInstanceContext(statementContext);
            StatementAgentInstanceFactoryUpdateResult resultOfStart = (StatementAgentInstanceFactoryUpdateResult)contextFactory.newContext(agentInstanceContext, isRecoveringResilient);
            finalViewable = resultOfStart.getFinalView();
            final StopCallback stopCallback = services.getEpStatementFactory().makeStopMethod(resultOfStart);
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    stopCallback.stop();
                    stopMethod.stop();
                }
            };
            subselectStrategyInstances = resultOfStart.getSubselectStrategies();
            if (statementContext.getStatementExtensionServicesContext() != null && statementContext.getStatementExtensionServicesContext().getStmtResources() != null) {
                StatementResourceHolder holder = statementContext.getStatementExtensionServicesContext().extractStatementResourceHolder(resultOfStart);
                statementContext.getStatementExtensionServicesContext().getStmtResources().setUnpartitioned(holder);
                statementContext.getStatementExtensionServicesContext().postProcessStart(resultOfStart, isRecoveringResilient);
            }
        }
        EPStatementStartMethodHelperAssignExpr.assignSubqueryStrategies(subSelectStrategyCollection, subselectStrategyInstances);
        return new EPStatementStartResult(finalViewable, stopStatementMethod, destroyCallbacks);
    }
}

