/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dispatch;

import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.dispatch.Dispatchable;
import java.util.ArrayDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchServiceImpl
implements DispatchService {
    private final ThreadLocal<ArrayDeque<Dispatchable>> threadDispatchQueue = new ThreadLocal<ArrayDeque<Dispatchable>>(){

        @Override
        protected synchronized ArrayDeque<Dispatchable> initialValue() {
            return new ArrayDeque<Dispatchable>();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DispatchServiceImpl.class);

    @Override
    public void dispatch() {
        DispatchServiceImpl.dispatchFromQueue(this.threadDispatchQueue.get());
    }

    @Override
    public void addExternal(Dispatchable dispatchable) {
        ArrayDeque<Dispatchable> dispatchQueue = this.threadDispatchQueue.get();
        DispatchServiceImpl.addToQueue(dispatchable, dispatchQueue);
    }

    private static void addToQueue(Dispatchable dispatchable, ArrayDeque<Dispatchable> dispatchQueue) {
        dispatchQueue.add(dispatchable);
    }

    private static void dispatchFromQueue(ArrayDeque<Dispatchable> dispatchQueue) {
        Dispatchable next;
        while ((next = dispatchQueue.poll()) != null) {
            next.execute();
        }
    }
}

