/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggSvcGroupByUtil;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodPairRow;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByRefcountedWAccessRollupImpl
extends AggregationServiceBaseGrouped {
    protected final AggregationAccessorSlotPair[] accessors;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    protected final AggregationGroupByRollupDesc rollupLevelDesc;
    protected Map<Object, AggregationMethodPairRow>[] aggregatorsPerGroup;
    protected AggregationMethodPairRow aggregatorTopGroup;
    private AggregationMethod[] currentAggregatorMethods;
    private AggregationState[] currentAggregatorStates;
    private Object currentGroupKey;
    protected final Object[] methodParameterValues;
    protected boolean hasRemovedKey;
    protected final List<Object>[] removedKeys;

    public AggSvcGroupByRefcountedWAccessRollupImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggregations, boolean isJoin, AggregationGroupByRollupDesc rollupLevelDesc, AggregationMethod[] topGroupAggregators, AggregationState[] topGroupStates) {
        super(evaluators, prototypes);
        this.aggregatorsPerGroup = new Map[rollupLevelDesc.getNumLevelsAggregation()];
        this.removedKeys = new ArrayList[rollupLevelDesc.getNumLevelsAggregation()];
        for (int i = 0; i < rollupLevelDesc.getNumLevelsAggregation(); ++i) {
            this.aggregatorsPerGroup[i] = new HashMap<Object, AggregationMethodPairRow>();
            this.removedKeys[i] = new ArrayList<Object>(2);
        }
        this.accessors = accessors;
        this.accessAggregations = accessAggregations;
        this.isJoin = isJoin;
        this.rollupLevelDesc = rollupLevelDesc;
        this.aggregatorTopGroup = new AggregationMethodPairRow(0L, topGroupAggregators, topGroupStates);
        this.methodParameterValues = new Object[evaluators.length];
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.aggregatorTopGroup.getStates()) {
            state.clear();
        }
        for (AggregationMethod aggregator : this.aggregatorTopGroup.getMethods()) {
            aggregator.clear();
        }
        for (int i = 0; i < this.rollupLevelDesc.getNumLevelsAggregation(); ++i) {
            this.aggregatorsPerGroup[i].clear();
        }
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object compositeGroupKey, ExprEvaluatorContext exprEvaluatorContext) {
        this.handleRemovedKeys();
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.methodParameterValues[i] = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        Object[] groupKeyPerLevel = (Object[])compositeGroupKey;
        for (int i = 0; i < groupKeyPerLevel.length; ++i) {
            int j;
            AggregationState[] groupStates;
            AggregationMethod[] groupAggregators;
            AggregationGroupByRollupLevel level = this.rollupLevelDesc.getLevels()[i];
            Object groupKey = groupKeyPerLevel[i];
            AggregationMethodPairRow row = !level.isAggregationTop() ? this.aggregatorsPerGroup[level.getAggregationOffset()].get(groupKey) : this.aggregatorTopGroup;
            if (row == null) {
                groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
                groupStates = AggSvcGroupByUtil.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupKey, null);
                row = new AggregationMethodPairRow(1L, groupAggregators, groupStates);
                if (!level.isAggregationTop()) {
                    this.aggregatorsPerGroup[level.getAggregationOffset()].put(groupKey, row);
                }
            } else {
                groupAggregators = row.getMethods();
                groupStates = row.getStates();
                row.increaseRefcount();
            }
            this.currentAggregatorMethods = groupAggregators;
            this.currentAggregatorStates = groupStates;
            for (j = 0; j < this.evaluators.length; ++j) {
                groupAggregators[j].enter(this.methodParameterValues[j]);
            }
            for (j = 0; j < this.currentAggregatorStates.length; ++j) {
                this.currentAggregatorStates[j].applyEnter(eventsPerStream, exprEvaluatorContext);
            }
            this.internalHandleGroupUpdate(groupKey, row, level);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object compositeGroupKey, ExprEvaluatorContext exprEvaluatorContext) {
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.methodParameterValues[i] = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
        }
        Object[] groupKeyPerLevel = (Object[])compositeGroupKey;
        for (int i = 0; i < groupKeyPerLevel.length; ++i) {
            int j;
            AggregationState[] groupStates;
            AggregationMethod[] groupAggregators;
            AggregationGroupByRollupLevel level = this.rollupLevelDesc.getLevels()[i];
            Object groupKey = groupKeyPerLevel[i];
            AggregationMethodPairRow row = !level.isAggregationTop() ? this.aggregatorsPerGroup[level.getAggregationOffset()].get(groupKey) : this.aggregatorTopGroup;
            if (row != null) {
                groupAggregators = row.getMethods();
                groupStates = row.getStates();
            } else {
                groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
                groupStates = AggSvcGroupByUtil.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupKey, null);
                row = new AggregationMethodPairRow(1L, groupAggregators, groupStates);
                if (!level.isAggregationTop()) {
                    this.aggregatorsPerGroup[level.getAggregationOffset()].put(groupKey, row);
                }
            }
            this.currentAggregatorMethods = groupAggregators;
            this.currentAggregatorStates = groupStates;
            for (j = 0; j < this.evaluators.length; ++j) {
                groupAggregators[j].leave(this.methodParameterValues[j]);
            }
            for (j = 0; j < this.currentAggregatorStates.length; ++j) {
                this.currentAggregatorStates[j].applyLeave(eventsPerStream, exprEvaluatorContext);
            }
            row.decreaseRefcount();
            if (row.getRefcount() <= 0L) {
                this.hasRemovedKey = true;
                if (!level.isAggregationTop()) {
                    this.removedKeys[level.getAggregationOffset()].add(groupKey);
                }
            }
            this.internalHandleGroupUpdate(groupKey, row, level);
        }
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        AggregationMethodPairRow row = rollupLevel.isAggregationTop() ? this.aggregatorTopGroup : this.aggregatorsPerGroup[rollupLevel.getAggregationOffset()].get(groupByKey);
        if (row != null) {
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorStates = row.getStates();
        } else {
            this.currentAggregatorMethods = null;
        }
        if (this.currentAggregatorMethods == null) {
            this.currentAggregatorMethods = AggSvcGroupByUtil.newAggregators(this.aggregators);
            this.currentAggregatorStates = AggSvcGroupByUtil.newAccesses(agentInstanceId, this.isJoin, this.accessAggregations, groupByKey, null);
        }
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableScalar(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    public void internalHandleGroupUpdate(Object groupByKey, AggregationMethodPairRow row, AggregationGroupByRollupLevel groupByRollupLevel) {
    }

    public void internalHandleGroupRemove(Object groupByKey, AggregationGroupByRollupLevel groupByRollupLevel) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.getGroupKeyCount(), this.aggregatorsPerGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.getGroupKeyCount());
        for (Map<Object, AggregationMethodPairRow> anAggregatorsPerGroup : this.aggregatorsPerGroup) {
            for (Map.Entry<Object, AggregationMethodPairRow> entry : anAggregatorsPerGroup.entrySet()) {
                visitor.visitGroup(entry.getKey(), entry.getValue());
            }
        }
        visitor.visitGroup(new Object[0], this.aggregatorTopGroup);
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    protected void handleRemovedKeys() {
        if (!this.hasRemovedKey) {
            return;
        }
        this.hasRemovedKey = false;
        for (int i = 0; i < this.removedKeys.length; ++i) {
            if (this.removedKeys[i].isEmpty()) continue;
            for (Object removedKey : this.removedKeys[i]) {
                this.aggregatorsPerGroup[i].remove(removedKey);
                this.internalHandleGroupRemove(removedKey, this.rollupLevelDesc.getLevels()[i]);
            }
            this.removedKeys[i].clear();
        }
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        throw new UnsupportedOperationException();
    }

    private int getGroupKeyCount() {
        int count = 1;
        for (Map<Object, AggregationMethodPairRow> anAggregatorsPerGroup : this.aggregatorsPerGroup) {
            count += anAggregatorsPerGroup.size();
        }
        return count;
    }
}

