/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.ConfigurationPlugInAggregationFunction;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.annotation.BuiltinAnnotation;
import com.espertech.esper.client.hook.AggregationFunctionFactory;
import com.espertech.esper.client.util.ClassForNameProvider;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.access.AggregationStateType;
import com.espertech.esper.epl.agg.factory.AggregationFactoryFactory;
import com.espertech.esper.epl.approx.CountMinSketchAggType;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.EngineNoSuchCtorException;
import com.espertech.esper.epl.core.EngineNoSuchMethodException;
import com.espertech.esper.epl.expression.accessagg.ExprAggCountMinSketchNode;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionSortedMinMaxByNode;
import com.espertech.esper.epl.expression.core.ExprCurrentEvaluationContextNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.methodagg.ExprCountEverNode;
import com.espertech.esper.epl.expression.methodagg.ExprFirstEverNode;
import com.espertech.esper.epl.expression.methodagg.ExprLastEverNode;
import com.espertech.esper.epl.expression.methodagg.ExprLeavingAggNode;
import com.espertech.esper.epl.expression.methodagg.ExprMinMaxAggrNode;
import com.espertech.esper.epl.expression.methodagg.ExprNthAggNode;
import com.espertech.esper.epl.expression.methodagg.ExprRateAggNode;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MethodResolver;
import com.espertech.esper.util.TransientConfigurationResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineImportServiceImpl
implements EngineImportService {
    private static final Logger log = LoggerFactory.getLogger(EngineImportServiceImpl.class);
    private final List<String> imports = new ArrayList<String>();
    private final List<String> annotationImports = new ArrayList<String>(2);
    private final Map<String, ConfigurationPlugInAggregationFunction> aggregationFunctions = new HashMap<String, ConfigurationPlugInAggregationFunction>();
    private final List<Pair<Set<String>, ConfigurationPlugInAggregationMultiFunction>> aggregationAccess = new ArrayList<Pair<Set<String>, ConfigurationPlugInAggregationMultiFunction>>();
    private final Map<String, EngineImportSingleRowDesc> singleRowFunctions = new HashMap<String, EngineImportSingleRowDesc>();
    private final Map<String, ConfigurationMethodRef> methodInvocationRef = new HashMap<String, ConfigurationMethodRef>();
    private final boolean allowExtendedAggregationFunc;
    private final boolean isUdfCache;
    private final boolean isDuckType;
    private final boolean sortUsingCollator;
    private final MathContext optionalDefaultMathContext;
    private final TimeZone timeZone;
    private final TimeAbacus timeAbacus;
    private final ConfigurationEngineDefaults.ThreadingProfile threadingProfile;
    private final Map<String, Object> transientConfiguration;
    private final AggregationFactoryFactory aggregationFactoryFactory;

    public EngineImportServiceImpl(boolean allowExtendedAggregationFunc, boolean isUdfCache, boolean isDuckType, boolean sortUsingCollator, MathContext optionalDefaultMathContext, TimeZone timeZone, TimeAbacus timeAbacus, ConfigurationEngineDefaults.ThreadingProfile threadingProfile, Map<String, Object> transientConfiguration, AggregationFactoryFactory aggregationFactoryFactory) {
        this.allowExtendedAggregationFunc = allowExtendedAggregationFunc;
        this.isUdfCache = isUdfCache;
        this.isDuckType = isDuckType;
        this.sortUsingCollator = sortUsingCollator;
        this.optionalDefaultMathContext = optionalDefaultMathContext;
        this.timeZone = timeZone;
        this.timeAbacus = timeAbacus;
        this.threadingProfile = threadingProfile;
        this.transientConfiguration = transientConfiguration;
        this.aggregationFactoryFactory = aggregationFactoryFactory;
    }

    @Override
    public boolean isUdfCache() {
        return this.isUdfCache;
    }

    @Override
    public boolean isDuckType() {
        return this.isDuckType;
    }

    @Override
    public ConfigurationMethodRef getConfigurationMethodRef(String className) {
        return this.methodInvocationRef.get(className);
    }

    @Override
    public ClassForNameProvider getClassForNameProvider() {
        return TransientConfigurationResolver.resolveClassForNameProvider(this.transientConfiguration);
    }

    @Override
    public ClassLoader getFastClassClassLoader(Class clazz) {
        return TransientConfigurationResolver.resolveFastClassClassLoaderProvider(this.transientConfiguration).classloader(clazz);
    }

    @Override
    public ClassLoader getClassLoader() {
        return TransientConfigurationResolver.resolveClassLoader(this.transientConfiguration).classloader();
    }

    public void addMethodRefs(Map<String, ConfigurationMethodRef> configs) {
        this.methodInvocationRef.putAll(configs);
    }

    @Override
    public void addImport(String importName) throws EngineImportException {
        this.validateImportAndAdd(importName, this.imports);
    }

    @Override
    public void addAnnotationImport(String importName) throws EngineImportException {
        this.validateImportAndAdd(importName, this.annotationImports);
    }

    @Override
    public void addAggregation(String functionName, ConfigurationPlugInAggregationFunction aggregationDesc) throws EngineImportException {
        this.validateFunctionName("aggregation function", functionName);
        if (aggregationDesc.getFactoryClassName() == null || !EngineImportServiceImpl.isClassName(aggregationDesc.getFactoryClassName())) {
            throw new EngineImportException("Invalid class name for aggregation factory '" + aggregationDesc.getFactoryClassName() + "'");
        }
        this.aggregationFunctions.put(functionName.toLowerCase(Locale.ENGLISH), aggregationDesc);
    }

    @Override
    public void addSingleRow(String functionName, String singleRowFuncClass, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache, ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions, String optionalEventTypeName) throws EngineImportException {
        this.validateFunctionName("single-row", functionName);
        if (!EngineImportServiceImpl.isClassName(singleRowFuncClass)) {
            throw new EngineImportException("Invalid class name for aggregation '" + singleRowFuncClass + "'");
        }
        this.singleRowFunctions.put(functionName.toLowerCase(Locale.ENGLISH), new EngineImportSingleRowDesc(singleRowFuncClass, methodName, valueCache, filterOptimizable, rethrowExceptions, optionalEventTypeName));
    }

    @Override
    public AggregationFunctionFactory resolveAggregationFactory(String name) throws EngineImportUndefinedException, EngineImportException {
        Object object;
        Class clazz;
        ConfigurationPlugInAggregationFunction desc = this.aggregationFunctions.get(name);
        if (desc == null) {
            desc = this.aggregationFunctions.get(name.toLowerCase(Locale.ENGLISH));
        }
        if (desc == null || desc.getFactoryClassName() == null) {
            throw new EngineImportUndefinedException("A function named '" + name + "' is not defined");
        }
        String className = desc.getFactoryClassName();
        try {
            clazz = this.getClassForNameProvider().classForName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load aggregation factory class by name '" + className + "'", ex);
        }
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineImportException("Error instantiating aggregation factory class by name '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new EngineImportException("Illegal access instatiating aggregation factory class by name '" + className + "'", e);
        }
        if (!(object instanceof AggregationFunctionFactory)) {
            throw new EngineImportException("Aggregation class by name '" + className + "' does not implement AggregationFunctionFactory");
        }
        return (AggregationFunctionFactory)object;
    }

    @Override
    public void addAggregationMultiFunction(ConfigurationPlugInAggregationMultiFunction desc) throws EngineImportException {
        LinkedHashSet<String> orderedImmutableFunctionNames = new LinkedHashSet<String>();
        for (String functionName : desc.getFunctionNames()) {
            orderedImmutableFunctionNames.add(functionName.toLowerCase(Locale.ENGLISH));
            this.validateFunctionName("aggregation multi-function", functionName.toLowerCase(Locale.ENGLISH));
        }
        if (!EngineImportServiceImpl.isClassName(desc.getMultiFunctionFactoryClassName())) {
            throw new EngineImportException("Invalid class name for aggregation multi-function factory '" + desc.getMultiFunctionFactoryClassName() + "'");
        }
        this.aggregationAccess.add(new Pair(orderedImmutableFunctionNames, desc));
    }

    @Override
    public ConfigurationPlugInAggregationMultiFunction resolveAggregationMultiFunction(String name) {
        for (Pair<Set<String>, ConfigurationPlugInAggregationMultiFunction> config : this.aggregationAccess) {
            if (!config.getFirst().contains(name.toLowerCase(Locale.ENGLISH))) continue;
            return config.getSecond();
        }
        return null;
    }

    @Override
    public Pair<Class, EngineImportSingleRowDesc> resolveSingleRow(String name) throws EngineImportException, EngineImportUndefinedException {
        Class clazz;
        EngineImportSingleRowDesc pair = this.singleRowFunctions.get(name);
        if (pair == null) {
            pair = this.singleRowFunctions.get(name.toLowerCase(Locale.ENGLISH));
        }
        if (pair == null) {
            throw new EngineImportUndefinedException("A function named '" + name + "' is not defined");
        }
        try {
            clazz = this.getClassForNameProvider().classForName(pair.getClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load single-row function class by name '" + pair.getClassName() + "'", ex);
        }
        return new Pair<Class, EngineImportSingleRowDesc>(clazz, pair);
    }

    @Override
    public Method resolveMethodOverloadChecked(String className, String methodName, Class[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, false);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, false, allowEventBeanType, allowEventBeanCollType);
        }
        catch (EngineNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, false);
        }
    }

    @Override
    public Constructor resolveCtor(Class clazz, Class[] paramTypes) throws EngineImportException {
        try {
            return MethodResolver.resolveCtor(clazz, paramTypes);
        }
        catch (EngineNoSuchCtorException e) {
            throw this.convert(clazz, paramTypes, e);
        }
    }

    @Override
    public Method resolveMethodOverloadChecked(String className, String methodName) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, false);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_STATIC_AND_PUBLIC);
    }

    @Override
    public Method resolveMethodOverloadChecked(Class clazz, String methodName) throws EngineImportException {
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_STATIC_AND_PUBLIC);
    }

    @Override
    public Method resolveNonStaticMethodOverloadChecked(Class clazz, String methodName) throws EngineImportException {
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_NONSTATIC_AND_PUBLIC);
    }

    @Override
    public Class resolveClass(String className, boolean forAnnotation) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, forAnnotation);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        return clazz;
    }

    @Override
    public Class resolveAnnotation(String className) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, true, true);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load annotation class by name '" + className + "', please check imports", e);
        }
        return clazz;
    }

    protected Class resolveClassInternal(String className, boolean requireAnnotation, boolean forAnnotationUse) throws ClassNotFoundException {
        try {
            return this.getClassForNameProvider().classForName(className);
        }
        catch (ClassNotFoundException e) {
            Class clazz;
            if (log.isDebugEnabled()) {
                log.debug("Class not found for resolving from name as-is '" + className + "'");
            }
            if (forAnnotationUse && (clazz = this.checkImports(this.annotationImports, requireAnnotation, className)) != null) {
                return clazz;
            }
            clazz = this.checkImports(this.imports, requireAnnotation, className);
            if (clazz != null) {
                return clazz;
            }
            if (!forAnnotationUse) {
                for (String name : this.methodInvocationRef.keySet()) {
                    if (!JavaClassHelper.isSimpleNameFullyQualfied(className, name)) continue;
                    try {
                        Class found = this.getClassForNameProvider().classForName(name);
                        if (requireAnnotation && !found.isAnnotation()) continue;
                        return found;
                    }
                    catch (ClassNotFoundException e1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Class not found for resolving from method invocation ref:" + name);
                    }
                }
            }
            throw new ClassNotFoundException("Unknown class " + className);
        }
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws EngineImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true, allowEventBeanType, allowEventBeanType);
        }
        catch (EngineNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, true);
        }
    }

    private EngineImportException convert(Class clazz, String methodName, Class[] paramTypes, EngineNoSuchMethodException e, boolean isInstance) {
        String expected = JavaClassHelper.getParameterAsString(paramTypes);
        String message = "Could not find ";
        message = !isInstance ? message + "static " : message + "enumeration method, date-time method or instance ";
        message = paramTypes.length > 0 ? message + "method named '" + methodName + "' in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : message + "method named '" + methodName + "' in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissMethod() != null) {
            message = message + " (nearest match found was '" + e.getNearestMissMethod().getName();
            message = e.getNearestMissMethod().getParameterTypes().length == 0 ? message + "' taking no parameters" : message + "' taking type(s) '" + JavaClassHelper.getParameterAsString(e.getNearestMissMethod().getParameterTypes()) + "'";
            message = message + ")";
        }
        return new EngineImportException(message, e);
    }

    private EngineImportException convert(Class clazz, Class[] paramTypes, EngineNoSuchCtorException e) {
        String expected = JavaClassHelper.getParameterAsString(paramTypes);
        String message = "Could not find constructor ";
        message = paramTypes.length > 0 ? message + "in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : message + "in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissCtor() != null) {
            message = message + " (nearest matching constructor ";
            message = e.getNearestMissCtor().getParameterTypes().length == 0 ? message + "taking no parameters" : message + "taking type(s) '" + JavaClassHelper.getParameterAsString(e.getNearestMissCtor().getParameterTypes()) + "'";
            message = message + ")";
        }
        return new EngineImportException(message, e);
    }

    @Override
    public ExprNode resolveSingleRowExtendedBuiltin(String name) {
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (nameLowerCase.equals("current_evaluation_context")) {
            return new ExprCurrentEvaluationContextNode();
        }
        return null;
    }

    @Override
    public ExprNode resolveAggExtendedBuiltin(String name, boolean isDistinct) {
        if (!this.allowExtendedAggregationFunc) {
            return null;
        }
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (nameLowerCase.equals("first")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationStateType.FIRST);
        }
        if (nameLowerCase.equals("last")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationStateType.LAST);
        }
        if (nameLowerCase.equals("window")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationStateType.WINDOW);
        }
        if (nameLowerCase.equals("firstever")) {
            return new ExprFirstEverNode(isDistinct);
        }
        if (nameLowerCase.equals("lastever")) {
            return new ExprLastEverNode(isDistinct);
        }
        if (nameLowerCase.equals("countever")) {
            return new ExprCountEverNode(isDistinct);
        }
        if (nameLowerCase.equals("minever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MIN, false, true);
        }
        if (nameLowerCase.equals("maxever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MAX, false, true);
        }
        if (nameLowerCase.equals("fminever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MIN, true, true);
        }
        if (nameLowerCase.equals("fmaxever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MAX, true, true);
        }
        if (nameLowerCase.equals("rate")) {
            return new ExprRateAggNode(isDistinct);
        }
        if (nameLowerCase.equals("nth")) {
            return new ExprNthAggNode(isDistinct);
        }
        if (nameLowerCase.equals("leaving")) {
            return new ExprLeavingAggNode(isDistinct);
        }
        if (nameLowerCase.equals("maxby")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(true, false, false);
        }
        if (nameLowerCase.equals("maxbyever")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(true, true, false);
        }
        if (nameLowerCase.equals("minby")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, false, false);
        }
        if (nameLowerCase.equals("minbyever")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, true, false);
        }
        if (nameLowerCase.equals("sorted")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, false, true);
        }
        CountMinSketchAggType cmsType = CountMinSketchAggType.fromNameMayMatch(nameLowerCase);
        if (cmsType != null) {
            return new ExprAggCountMinSketchNode(isDistinct, cmsType);
        }
        return null;
    }

    @Override
    public MathContext getDefaultMathContext() {
        return this.optionalDefaultMathContext;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }

    @Override
    public ConfigurationEngineDefaults.ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    @Override
    public boolean isSortUsingCollator() {
        return this.sortUsingCollator;
    }

    @Override
    public AggregationFactoryFactory getAggregationFactoryFactory() {
        return this.aggregationFactoryFactory;
    }

    protected String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    private static boolean isFunctionName(String functionName) {
        String classNameRegEx = "\\w+";
        return functionName.matches(classNameRegEx);
    }

    private static boolean isClassName(String importName) {
        String classNameRegEx = "(\\w+\\.)*\\w+(\\$\\w+)?";
        return importName.matches(classNameRegEx);
    }

    private static boolean isPackageName(String importName) {
        String classNameRegEx = "(\\w+\\.)+\\*";
        return importName.matches(classNameRegEx);
    }

    private static String getPackageName(String importName) {
        return importName.substring(0, importName.length() - 2);
    }

    private void validateFunctionName(String functionType, String functionName) throws EngineImportException {
        String functionNameLower = functionName.toLowerCase(Locale.ENGLISH);
        if (this.aggregationFunctions.containsKey(functionNameLower)) {
            throw new EngineImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (this.singleRowFunctions.containsKey(functionNameLower)) {
            throw new EngineImportException("Single-row function by name '" + functionName + "' is already defined");
        }
        for (Pair<Set<String>, ConfigurationPlugInAggregationMultiFunction> pairs : this.aggregationAccess) {
            if (!pairs.getFirst().contains(functionNameLower)) continue;
            throw new EngineImportException("Aggregation multi-function by name '" + functionName + "' is already defined");
        }
        if (!EngineImportServiceImpl.isFunctionName(functionName)) {
            throw new EngineImportException("Invalid " + functionType + " name '" + functionName + "'");
        }
    }

    private Method resolveMethodInternalCheckOverloads(Class clazz, String methodName, MethodModifiers methodModifiers) throws EngineImportException {
        Method[] methods = clazz.getMethods();
        HashSet<Method> overloadeds = null;
        Method methodByName = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            int modifiers = method.getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            boolean isStatic = Modifier.isStatic(modifiers);
            if (!methodModifiers.acceptsPublicFlag(isPublic) || !methodModifiers.acceptsStaticFlag(isStatic)) continue;
            if (methodByName != null) {
                if (overloadeds == null) {
                    overloadeds = new HashSet<Method>();
                }
                overloadeds.add(method);
                continue;
            }
            methodByName = method;
        }
        if (methodByName == null) {
            throw new EngineImportException("Could not find " + methodModifiers.getText() + " method named '" + methodName + "' in class '" + clazz.getName() + "'");
        }
        if (overloadeds == null) {
            return methodByName;
        }
        for (Method overloaded : overloadeds) {
            if (overloaded.getReturnType().equals(methodByName.getReturnType())) continue;
            throw new EngineImportException("Method by name '" + methodName + "' is overloaded in class '" + clazz.getName() + "' and overloaded methods do not return the same type");
        }
        return methodByName;
    }

    private Class checkImports(List<String> imports, boolean requireAnnotation, String className) throws ClassNotFoundException {
        for (String importName : imports) {
            Class clazz;
            Class clazz2;
            String prefixedClassName;
            boolean isClassName = EngineImportServiceImpl.isClassName(importName);
            boolean containsPackage = importName.indexOf(46) != -1;
            String classNameWithDot = "." + className;
            String classNameWithDollar = "$" + className;
            if (isClassName) {
                if (containsPackage && importName.endsWith(classNameWithDot) || containsPackage && importName.endsWith(classNameWithDollar) || !containsPackage && importName.equals(className) || !containsPackage && importName.endsWith(classNameWithDollar)) {
                    return this.getClassForNameProvider().classForName(importName);
                }
                prefixedClassName = importName + '$' + className;
                try {
                    clazz2 = this.getClassForNameProvider().classForName(prefixedClassName);
                    if (requireAnnotation && !clazz2.isAnnotation()) continue;
                    return clazz2;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Class not found for resolving from name '" + prefixedClassName + "'");
                    continue;
                }
            }
            if (requireAnnotation && importName.equals(Configuration.ANNOTATION_IMPORT) && (clazz = BuiltinAnnotation.BUILTIN.get(className.toLowerCase(Locale.ENGLISH))) != null) {
                return clazz;
            }
            prefixedClassName = EngineImportServiceImpl.getPackageName(importName) + '.' + className;
            try {
                clazz2 = this.getClassForNameProvider().classForName(prefixedClassName);
                if (requireAnnotation && !clazz2.isAnnotation()) continue;
                return clazz2;
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Class not found for resolving from name '" + prefixedClassName + "'");
            }
        }
        return null;
    }

    private void validateImportAndAdd(String importName, List<String> imports) throws EngineImportException {
        if (!EngineImportServiceImpl.isClassName(importName) && !EngineImportServiceImpl.isPackageName(importName)) {
            throw new EngineImportException("Invalid import name '" + importName + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding import " + importName);
        }
        imports.add(importName);
    }

    private static enum MethodModifiers {
        REQUIRE_STATIC_AND_PUBLIC("public static", true),
        REQUIRE_NONSTATIC_AND_PUBLIC("public non-static", false);

        private final String text;
        private final boolean requiredStaticFlag;

        private MethodModifiers(String text, boolean requiredStaticFlag) {
            this.text = text;
            this.requiredStaticFlag = requiredStaticFlag;
        }

        public boolean acceptsPublicFlag(boolean isPublic) {
            return isPublic;
        }

        public boolean acceptsStaticFlag(boolean isStatic) {
            return this.requiredStaticFlag == isStatic;
        }

        public String getText() {
            return this.text;
        }
    }
}

