/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetAggregateAllIterator;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAllOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAllOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorOutputHelperVisitor;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ResultSetProcessorAggregateAll
implements ResultSetProcessor {
    private final ResultSetProcessorAggregateAllFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private ExprEvaluatorContext exprEvaluatorContext;
    private ResultSetProcessorAggregateAllOutputLastHelper outputLastUnordHelper;
    private ResultSetProcessorAggregateAllOutputAllHelper outputAllUnordHelper;

    public ResultSetProcessorAggregateAll(ResultSetProcessorAggregateAllFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.exprEvaluatorContext = agentInstanceContext;
        this.outputLastUnordHelper = prototype.isEnableOutputLimitOpt() && prototype.isOutputLast() ? prototype.getResultSetProcessorHelperFactory().makeRSAggregateAllOutputLast(this, agentInstanceContext) : null;
        this.outputAllUnordHelper = prototype.isEnableOutputLimitOpt() && prototype.isOutputAll() ? prototype.getResultSetProcessorHelperFactory().makeRSAggregateAllOutputAll(this, agentInstanceContext) : null;
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext context) {
        this.exprEvaluatorContext = context;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        EventBean[] eventsPerStream = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.aggregationService, this.exprEvaluatorContext, newData, oldData, eventsPerStream);
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        ResultSetProcessorUtil.applyAggJoinResult(this.aggregationService, this.exprEvaluatorContext, newEvents, oldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        ResultSetProcessorUtil.applyAggJoinResult(this.aggregationService, this.exprEvaluatorContext, newEvents, oldEvents);
        if (this.prototype.getOptionalHavingNode() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, oldEvents, false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldEvents, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, newEvents, true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newEvents, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, oldEvents, this.prototype.getOptionalHavingNode(), false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.prototype.getOptionalHavingNode(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, newEvents, this.prototype.getOptionalHavingNode(), true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newEvents, this.prototype.getOptionalHavingNode(), true, isSynthesize, this.exprEvaluatorContext);
        }
        if (selectNewEvents == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        EventBean[] eventsPerStream = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.aggregationService, this.exprEvaluatorContext, newData, oldData, eventsPerStream);
        if (this.prototype.getOptionalHavingNode() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, oldData, false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingNode(), false, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, this.prototype.getOptionalHavingNode(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingNode(), true, isSynthesize, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, this.prototype.getOptionalHavingNode(), true, isSynthesize, this.exprEvaluatorContext);
        }
        if (selectNewEvents == null && selectOldEvents == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator(parent);
        }
        ResultSetProcessorUtil.clearAndAggregateUngrouped(this.exprEvaluatorContext, this.aggregationService, parent);
        ArrayDeque<EventBean> deque = ResultSetProcessorUtil.iteratorToDeque(this.obtainIterator(parent));
        this.aggregationService.clearResults(this.exprEvaluatorContext);
        return deque.iterator();
    }

    public Iterator<EventBean> obtainIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateAllIterator(parent.iterator(), this, this.exprEvaluatorContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<Object> orderKeys = new ArrayList<Object>();
        Iterator<EventBean> iterator = parent.iterator();
        while (iterator.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = iterator.next();
            Boolean pass = true;
            if (this.prototype.getOptionalHavingNode() != null) {
                pass = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, true, this.exprEvaluatorContext);
            }
            if (pass == null || !pass.booleanValue()) continue;
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true, this.exprEvaluatorContext));
            Object orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.exprEvaluatorContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        Object[] orderKeysArr = orderKeys.toArray(new Object[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.exprEvaluatorContext);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.prototype.getOptionalHavingNode();
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        EventBean[] result = this.prototype.getOptionalHavingNode() == null ? (this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, joinSet, true, true, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, joinSet, true, true, this.exprEvaluatorContext)) : (this.orderByProcessor == null ? ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, joinSet, this.prototype.getOptionalHavingNode(), true, true, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, joinSet, this.prototype.getOptionalHavingNode(), true, true, this.exprEvaluatorContext));
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.exprEvaluatorContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedJoinLast(joinEventsSet, generateSynthetic);
        }
        return this.processOutputLimitedJoinDefault(joinEventsSet, generateSynthetic);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedViewLast(viewEventsList, generateSynthetic);
        }
        return this.processOutputLimitedViewDefault(viewEventsList, generateSynthetic);
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllUnordHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastUnordHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllUnordHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        } else {
            this.outputLastUnordHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllUnordHelper.output();
        }
        return this.outputLastUnordHelper.output();
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllUnordHelper.output();
        }
        return this.outputLastUnordHelper.output();
    }

    @Override
    public void stop() {
        if (this.outputLastUnordHelper != null) {
            this.outputLastUnordHelper.destroy();
        }
        if (this.outputAllUnordHelper != null) {
            this.outputAllUnordHelper.destroy();
        }
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinDefault(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> row : newData) {
                    this.aggregationService.applyEnter(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> row : oldData) {
                    this.aggregationService.applyLeave(row.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.isSelectRStream()) {
                if (this.prototype.getOptionalHavingNode() == null) {
                    if (this.orderByProcessor == null) {
                        ResultSetProcessorUtil.populateSelectJoinEventsNoHaving(this.selectExprProcessor, oldData, false, generateSynthetic, oldEvents, this.exprEvaluatorContext);
                    } else {
                        ResultSetProcessorUtil.populateSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, false, generateSynthetic, oldEvents, oldEventsSortKey, this.exprEvaluatorContext);
                    }
                } else if (this.orderByProcessor == null) {
                    ResultSetProcessorUtil.populateSelectJoinEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, oldEvents, this.exprEvaluatorContext);
                } else {
                    ResultSetProcessorUtil.populateSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, oldEvents, oldEventsSortKey, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.getOptionalHavingNode() == null) {
                if (this.orderByProcessor == null) {
                    ResultSetProcessorUtil.populateSelectJoinEventsNoHaving(this.selectExprProcessor, newData, true, generateSynthetic, newEvents, this.exprEvaluatorContext);
                    continue;
                }
                ResultSetProcessorUtil.populateSelectJoinEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, true, generateSynthetic, newEvents, newEventsSortKey, this.exprEvaluatorContext);
                continue;
            }
            if (this.orderByProcessor == null) {
                ResultSetProcessorUtil.populateSelectJoinEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, newEvents, this.exprEvaluatorContext);
                continue;
            }
            ResultSetProcessorUtil.populateSelectJoinEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, newEvents, newEventsSortKey, this.exprEvaluatorContext);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinLast(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        EventBean[] lastOld;
        EventBean[] eventBeanArray;
        EventBean[] lastNew;
        EventBean[] eventBeanArray2;
        EventBean lastOldEvent = null;
        EventBean lastNewEvent = null;
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            EventBean[] selectNewEvents;
            EventBean[] selectOldEvents;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> eventsPerStream : newData) {
                    this.aggregationService.applyEnter(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> eventsPerStream : oldData) {
                    this.aggregationService.applyLeave(eventsPerStream.getArray(), null, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.isSelectRStream() && (selectOldEvents = this.prototype.getOptionalHavingNode() == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, oldData, false, generateSynthetic, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, this.exprEvaluatorContext)) != null && selectOldEvents.length > 0) {
                lastOldEvent = selectOldEvents[selectOldEvents.length - 1];
            }
            if ((selectNewEvents = this.prototype.getOptionalHavingNode() == null ? ResultSetProcessorUtil.getSelectJoinEventsNoHaving(this.selectExprProcessor, newData, true, generateSynthetic, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectJoinEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, this.exprEvaluatorContext)) == null || selectNewEvents.length <= 0) continue;
            lastNewEvent = selectNewEvents[selectNewEvents.length - 1];
        }
        if (lastNewEvent != null) {
            EventBean[] eventBeanArray3 = new EventBean[1];
            eventBeanArray2 = eventBeanArray3;
            eventBeanArray3[0] = lastNewEvent;
        } else {
            eventBeanArray2 = lastNew = null;
        }
        if (lastOldEvent != null) {
            EventBean[] eventBeanArray4 = new EventBean[1];
            eventBeanArray = eventBeanArray4;
            eventBeanArray4[0] = lastOldEvent;
        } else {
            eventBeanArray = lastOld = null;
        }
        if (lastNew == null && lastOld == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(lastNew, lastOld);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewDefault(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int n;
            int n2;
            EventBean[] eventBeanArray;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                eventBeanArray = newData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = eventBeanArray[n];
                    this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                eventBeanArray = oldData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = eventBeanArray[n];
                    this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.isSelectRStream()) {
                if (this.prototype.getOptionalHavingNode() == null) {
                    if (this.orderByProcessor == null) {
                        ResultSetProcessorUtil.populateSelectEventsNoHaving(this.selectExprProcessor, oldData, false, generateSynthetic, oldEvents, this.exprEvaluatorContext);
                    } else {
                        ResultSetProcessorUtil.populateSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, false, generateSynthetic, oldEvents, oldEventsSortKey, this.exprEvaluatorContext);
                    }
                } else if (this.orderByProcessor == null) {
                    ResultSetProcessorUtil.populateSelectEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, oldEvents, this.exprEvaluatorContext);
                } else {
                    ResultSetProcessorUtil.populateSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, oldEvents, oldEventsSortKey, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.getOptionalHavingNode() == null) {
                if (this.orderByProcessor == null) {
                    ResultSetProcessorUtil.populateSelectEventsNoHaving(this.selectExprProcessor, newData, true, generateSynthetic, newEvents, this.exprEvaluatorContext);
                    continue;
                }
                ResultSetProcessorUtil.populateSelectEventsNoHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, true, generateSynthetic, newEvents, newEventsSortKey, this.exprEvaluatorContext);
                continue;
            }
            if (this.orderByProcessor == null) {
                ResultSetProcessorUtil.populateSelectEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, newEvents, this.exprEvaluatorContext);
                continue;
            }
            ResultSetProcessorUtil.populateSelectEventsHavingWithOrderBy(this.selectExprProcessor, this.orderByProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, newEvents, newEventsSortKey, this.exprEvaluatorContext);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.exprEvaluatorContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.exprEvaluatorContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewLast(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        EventBean[] lastOld;
        EventBean[] eventBeanArray;
        EventBean[] lastNew;
        EventBean[] eventBeanArray2;
        EventBean lastOldEvent = null;
        EventBean lastNewEvent = null;
        EventBean[] eventsPerStream = new EventBean[1];
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            EventBean[] selectNewEvents;
            EventBean[] selectOldEvents;
            int n;
            int n2;
            EventBean[] eventBeanArray3;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                eventBeanArray3 = newData;
                n2 = eventBeanArray3.length;
                for (n = 0; n < n2; ++n) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = eventBeanArray3[n];
                    this.aggregationService.applyEnter(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (oldData != null) {
                eventBeanArray3 = oldData;
                n2 = eventBeanArray3.length;
                for (n = 0; n < n2; ++n) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = eventBeanArray3[n];
                    this.aggregationService.applyLeave(eventsPerStream, null, this.exprEvaluatorContext);
                }
            }
            if (this.prototype.isSelectRStream() && (selectOldEvents = this.prototype.getOptionalHavingNode() == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, oldData, false, generateSynthetic, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, oldData, this.prototype.getOptionalHavingNode(), false, generateSynthetic, this.exprEvaluatorContext)) != null && selectOldEvents.length > 0) {
                lastOldEvent = selectOldEvents[selectOldEvents.length - 1];
            }
            if ((selectNewEvents = this.prototype.getOptionalHavingNode() == null ? ResultSetProcessorUtil.getSelectEventsNoHaving(this.selectExprProcessor, newData, true, generateSynthetic, this.exprEvaluatorContext) : ResultSetProcessorUtil.getSelectEventsHaving(this.selectExprProcessor, newData, this.prototype.getOptionalHavingNode(), true, generateSynthetic, this.exprEvaluatorContext)) == null || selectNewEvents.length <= 0) continue;
            lastNewEvent = selectNewEvents[selectNewEvents.length - 1];
        }
        if (lastNewEvent != null) {
            EventBean[] eventBeanArray4 = new EventBean[1];
            eventBeanArray2 = eventBeanArray4;
            eventBeanArray4[0] = lastNewEvent;
        } else {
            eventBeanArray2 = lastNew = null;
        }
        if (lastOldEvent != null) {
            EventBean[] eventBeanArray5 = new EventBean[1];
            eventBeanArray = eventBeanArray5;
            eventBeanArray5[0] = lastOldEvent;
        } else {
            eventBeanArray = lastOld = null;
        }
        if (lastNew == null && lastOld == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(lastNew, lastOld);
    }

    @Override
    public void acceptHelperVisitor(ResultSetProcessorOutputHelperVisitor visitor) {
        if (this.outputLastUnordHelper != null) {
            visitor.visit(this.outputLastUnordHelper);
        }
        if (this.outputAllUnordHelper != null) {
            visitor.visit(this.outputAllUnordHelper);
        }
    }
}

