/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorGroupedOutputAllGroupReps;
import com.espertech.esper.epl.core.ResultSetProcessorGroupedOutputFirstHelper;
import com.espertech.esper.epl.core.ResultSetProcessorOutputHelperVisitor;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.ResultSetRowPerGroupIterator;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorRowPerGroup
implements ResultSetProcessor,
AggregationRowRemovedCallback {
    protected final ResultSetProcessorRowPerGroupFactory prototype;
    protected final SelectExprProcessor selectExprProcessor;
    protected final OrderByProcessor orderByProcessor;
    protected final AggregationService aggregationService;
    protected AgentInstanceContext agentInstanceContext;
    protected ResultSetProcessorGroupedOutputAllGroupReps outputAllGroupReps;
    private ResultSetProcessorGroupedOutputFirstHelper outputFirstHelper;
    private ResultSetProcessorRowPerGroupOutputLastHelper outputLastHelper;
    private ResultSetProcessorRowPerGroupOutputAllHelper outputAllHelper;

    public ResultSetProcessorRowPerGroup(ResultSetProcessorRowPerGroupFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.agentInstanceContext = agentInstanceContext;
        aggregationService.setRemovedCallback(this);
        if (prototype.isOutputLast()) {
            this.outputLastHelper = prototype.getResultSetProcessorHelperFactory().makeRSRowPerGroupOutputLastOpt(agentInstanceContext, this, prototype);
        } else if (prototype.isOutputAll()) {
            if (!prototype.isEnableOutputLimitOpt()) {
                this.outputAllGroupReps = prototype.getResultSetProcessorHelperFactory().makeRSGroupedOutputAllNoOpt(agentInstanceContext, prototype.getGroupKeyNodes(), prototype.getNumStreams());
            } else {
                this.outputAllHelper = prototype.getResultSetProcessorHelperFactory().makeRSRowPerGroupOutputAllOpt(agentInstanceContext, this, prototype);
            }
        } else if (prototype.isOutputFirst()) {
            this.outputFirstHelper = prototype.getResultSetProcessorHelperFactory().makeRSGroupedOutputFirst(agentInstanceContext, prototype.getGroupKeyNodes(), prototype.getOptionalOutputFirstConditionFactory(), null, -1);
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext agentInstanceContext) {
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        Object mk;
        int n;
        int n2;
        EventBean[] eventBeanArray;
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            eventBeanArray = newData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                EventBean aNewData;
                eventsPerStream[0] = aNewData = eventBeanArray[n];
                mk = this.generateGroupKey(eventsPerStream, true);
                this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            eventBeanArray = oldData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                EventBean anOldData;
                eventsPerStream[0] = anOldData = eventBeanArray[n];
                mk = this.generateGroupKey(eventsPerStream, false);
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        Object mk;
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), true);
                this.aggregationService.applyEnter(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), false);
                this.aggregationService.applyLeave(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        HashMap<Object, EventBean[]> keysAndEvents = new HashMap<Object, EventBean[]>();
        Object[] newDataMultiKey = this.generateGroupKeys(newEvents, keysAndEvents, true);
        Object[] oldDataMultiKey = this.generateGroupKeys(oldEvents, keysAndEvents, false);
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsJoin(keysAndEvents, false, isSynthesize);
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                ++count;
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                ++count;
            }
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        HashMap<Object, EventBean> keysAndEvents = new HashMap<Object, EventBean>();
        Object[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
        Object[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(keysAndEvents, false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(keysAndEvents, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    protected EventBean[] generateOutputEventsView(Map<Object, EventBean> keysAndEvents, boolean isNewData, boolean isSynthesize) {
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[keysAndEvents.size()];
        Object[] keys = new Object[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<Object, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[count] = entry.getKey();
            if (this.prototype.isSorting()) {
                EventBean[] currentEventsPerStream = new EventBean[]{entry.getValue()};
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[count];
            System.arraycopy(events, 0, outEvents, 0, count);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    private void generateOutputBatchedRow(Map<Object, EventBean> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys, AgentInstanceContext agentInstanceContext) {
        EventBean[] eventsPerStream = new EventBean[1];
        for (Map.Entry<Object, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, agentInstanceContext));
            if (!this.prototype.isSorting()) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, agentInstanceContext));
        }
    }

    public void generateOutputBatchedArr(boolean join, Iterator<Map.Entry<Object, EventBean[]>> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        while (keysAndEvents.hasNext()) {
            Map.Entry<Object, EventBean[]> entry = keysAndEvents.next();
            this.generateOutputBatchedRow(join, entry.getKey(), entry.getValue(), isNewData, isSynthesize, resultEvents, optSortKeys);
        }
    }

    private void generateOutputBatchedRow(boolean join, Object mk, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        Boolean result;
        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return;
        }
        resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
        if (this.prototype.isSorting()) {
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
        }
    }

    public EventBean generateOutputBatchedNoSortWMap(boolean join, Object mk, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        Boolean result;
        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return null;
        }
        return this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
    }

    private EventBean[] generateOutputEventsJoin(Map<Object, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize) {
        EventBean[] events = new EventBean[keysAndEvents.size()];
        Object[] keys = new Object[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<Object, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceId(), null);
            EventBean[] eventsPerStream = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[count] = entry.getKey();
            if (this.prototype.isSorting()) {
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[count];
            System.arraycopy(events, 0, outEvents, 0, count);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    private Object[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        Object[] keys = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    protected Object[] generateGroupKeys(EventBean[] events, Map<Object, EventBean> eventPerKey, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        Object[] keys = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
            eventPerKey.put(keys[i], events[i]);
        }
        return keys;
    }

    private Object[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, Map<Object, EventBean[]> eventPerKey, boolean isNewData) {
        if (resultSet == null || resultSet.isEmpty()) {
            return null;
        }
        Object[] keys = new Object[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            eventPerKey.put(keys[count], eventsPerStream.getArray());
            ++count;
        }
        return keys;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.prototype.getOptionalHavingNode();
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator(parent);
        }
        this.aggregationService.clearResults(this.agentInstanceContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.applyEnter(eventsPerStream, groupKey, this.agentInstanceContext);
        }
        ArrayDeque<EventBean> deque = ResultSetProcessorUtil.iteratorToDeque(this.obtainIterator(parent));
        this.aggregationService.clearResults(this.agentInstanceContext);
        return deque.iterator();
    }

    public Iterator<EventBean> obtainIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetRowPerGroupIterator(parent.iterator(), this, this.aggregationService, this.agentInstanceContext);
        }
        return this.getIteratorSorted(parent.iterator());
    }

    protected Iterator<EventBean> getIteratorSorted(Iterator<EventBean> parentIter) {
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<Object> orderKeys = new ArrayList<Object>();
        HashSet<Object> priorSeenGroups = new HashSet<Object>();
        while (parentIter.hasNext()) {
            Boolean pass;
            EventBean candidate;
            eventsPerStream[0] = candidate = parentIter.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((pass = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, true, this.agentInstanceContext)) == null || !pass.booleanValue()) || priorSeenGroups.contains(groupKey)) continue;
            priorSeenGroups.add(groupKey);
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true, this.agentInstanceContext));
            Object orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.agentInstanceContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        Object[] orderKeysArr = orderKeys.toArray(new Object[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.agentInstanceContext);
        return new ArrayEventIterator(orderedEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        HashMap<Object, EventBean[]> keysAndEvents = new HashMap<Object, EventBean[]>();
        this.generateGroupKeys(joinSet, keysAndEvents, true);
        EventBean[] selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, true, true);
        return new ArrayEventIterator(selectNewEvents);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.agentInstanceContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.processOutputLimitedJoinDefault(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.processOutputLimitedJoinAll(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.processOutputLimitedJoinFirst(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedJoinLast(joinEventsSet, generateSynthetic);
        }
        throw new IllegalStateException("Unrecognized output limit type " + (Object)((Object)outputLimitLimitType));
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.processOutputLimitedViewDefault(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.processOutputLimitedViewAll(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.processOutputLimitedViewFirst(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedViewLast(viewEventsList, generateSynthetic);
        }
        throw new IllegalStateException("Unrecognized output limit type " + (Object)((Object)outputLimitLimitType));
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void removed(Object key) {
        if (this.outputAllGroupReps != null) {
            this.outputAllGroupReps.remove(key);
        }
        if (this.outputLastHelper != null) {
            this.outputLastHelper.remove(key);
        }
        if (this.outputAllGroupReps != null) {
            this.outputAllGroupReps.remove(key);
        }
        if (this.outputFirstHelper != null) {
            this.outputFirstHelper.remove(key);
        }
    }

    public Object generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.prototype.getGroupKeyNode() != null) {
            return this.prototype.getGroupKeyNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        ExprEvaluator[] evals = this.prototype.getGroupKeyNodes();
        Object[] keys = new Object[evals.length];
        for (int i = 0; i < evals.length; ++i) {
            keys[i] = evals[i].evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(keys);
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processJoin(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }

    @Override
    public void stop() {
        if (this.outputAllGroupReps != null) {
            this.outputAllGroupReps.destroy();
        }
        if (this.outputAllHelper != null) {
            this.outputAllHelper.destroy();
        }
        if (this.outputLastHelper != null) {
            this.outputLastHelper.destroy();
        }
        if (this.outputFirstHelper != null) {
            this.outputFirstHelper.destroy();
        }
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }

    @Override
    public void acceptHelperVisitor(ResultSetProcessorOutputHelperVisitor visitor) {
        if (this.outputAllGroupReps != null) {
            visitor.visit(this.outputAllGroupReps);
        }
        if (this.outputFirstHelper != null) {
            visitor.visit(this.outputFirstHelper);
        }
        if (this.outputLastHelper != null) {
            visitor.visit(this.outputLastHelper);
        }
        if (this.outputAllHelper != null) {
            visitor.visit(this.outputAllHelper);
        }
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinLast(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        LinkedHashMap<Object, EventBean[]> groupRepsView = new LinkedHashMap<Object, EventBean[]>();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            Object mk;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    mk = this.generateGroupKey(aNewData.getArray(), true);
                    if (groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(true, mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = this.generateGroupKey(anOldData.getArray(), true);
                if (groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedRow(true, mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(true, groupRepsView.entrySet().iterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinFirst(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        Set<MultiKey<EventBean>> oldData;
        Set<MultiKey<EventBean>> newData;
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        LinkedHashMap<Object, EventBean[]> groupRepsView = new LinkedHashMap<Object, EventBean[]>();
        if (this.prototype.getOptionalHavingNode() == null) {
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Object mk;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                if (newData != null) {
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = this.generateGroupKey(aNewData.getArray(), true);
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass && groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatchedRow(true, mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                    }
                }
                if (oldData == null) continue;
                for (MultiKey<EventBean> anOldData : oldData) {
                    mk = this.generateGroupKey(anOldData.getArray(), true);
                    outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                    pass = outputStateGroup.updateOutputCondition(0, 1);
                    if (pass && groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(true, mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
                }
            }
        } else {
            groupRepsView.clear();
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Boolean result;
                Object mk;
                int count;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = newDataMultiKey[count];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aNewData.getArray(), true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) {
                            ++count;
                            continue;
                        }
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass && groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatchedRow(true, mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        ++count;
                    }
                }
                if (oldData == null) continue;
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    mk = oldDataMultiKey[count];
                    this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                    result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(anOldData.getArray(), false, this.agentInstanceContext);
                    if (result == null || !result.booleanValue()) {
                        ++count;
                        continue;
                    }
                    outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                    pass = outputStateGroup.updateOutputCondition(0, 1);
                    if (pass && groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(true, mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    ++count;
                }
            }
        }
        this.generateOutputBatchedArr(true, groupRepsView.entrySet().iterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinAll(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        if (this.prototype.isSelectRStream()) {
            this.generateOutputBatchedArr(true, this.outputAllGroupReps.entryIterator(), false, generateSynthetic, oldEvents, oldEventsSortKey);
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            Object mk;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    mk = this.generateGroupKey(aNewData.getArray(), true);
                    if (this.outputAllGroupReps.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(true, mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = this.generateGroupKey(anOldData.getArray(), true);
                if (this.outputAllGroupReps.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedRow(true, mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(true, this.outputAllGroupReps.entryIterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinDefault(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        HashMap<Object, EventBean[]> keysAndEvents = new HashMap<Object, EventBean[]>();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            Object[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedArr(true, keysAndEvents.entrySet().iterator(), false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            this.generateOutputBatchedArr(true, keysAndEvents.entrySet().iterator(), true, generateSynthetic, newEvents, newEventsSortKey);
            keysAndEvents.clear();
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewLast(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        LinkedHashMap<Object, EventBean[]> groupRepsView = new LinkedHashMap<Object, EventBean[]>();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            Object mk;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                mk = this.generateGroupKey(eventsPerStream, true);
                if (groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(false, groupRepsView.entrySet().iterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    /*
     * WARNING - void declaration
     */
    private UniformPair<EventBean[]> processOutputLimitedViewFirst(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        void var9_16;
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        LinkedHashMap<Object, EventBean[]> groupRepsView = new LinkedHashMap<Object, EventBean[]>();
        if (this.prototype.getOptionalHavingNode() == null) {
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Object mk;
                EventBean[] eventsPerStream;
                EventBean[] eventBeanArray = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                if (eventBeanArray != null) {
                    for (EventBean aNewData : eventBeanArray) {
                        eventsPerStream = new EventBean[]{aNewData};
                        mk = this.generateGroupKey(eventsPerStream, true);
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass && groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                    }
                }
                if (oldData == null) continue;
                for (EventBean anOldData : oldData) {
                    eventsPerStream = new EventBean[]{anOldData};
                    mk = this.generateGroupKey(eventsPerStream, true);
                    outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                    pass = outputStateGroup.updateOutputCondition(0, 1);
                    if (pass && groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
                }
            }
        } else {
            EventBean[] eventsPerStreamOneStream = new EventBean[1];
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                EventBean[] eventsPerStream;
                OutputConditionPolled outputStateGroup;
                boolean pass;
                Boolean result;
                Object mk;
                int i;
                EventBean[] newData = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    for (i = 0; i < newData.length; ++i) {
                        eventsPerStreamOneStream[0] = newData[i];
                        this.aggregationService.applyEnter(eventsPerStreamOneStream, newDataMultiKey[i], this.agentInstanceContext);
                    }
                }
                if (oldData != null) {
                    for (i = 0; i < oldData.length; ++i) {
                        eventsPerStreamOneStream[0] = oldData[i];
                        this.aggregationService.applyLeave(eventsPerStreamOneStream, oldDataMultiKey[i], this.agentInstanceContext);
                    }
                }
                if (newData != null) {
                    for (i = 0; i < newData.length; ++i) {
                        mk = newDataMultiKey[i];
                        eventsPerStreamOneStream[0] = newData[i];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStreamOneStream, true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue() || !(pass = (outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory())).updateOutputCondition(0, 1)) || groupRepsView.put(mk, eventsPerStream = new EventBean[]{newData[i]}) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatchedRow(false, mk, eventsPerStream, true, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                }
                if (oldData == null) continue;
                for (i = 0; i < oldData.length; ++i) {
                    mk = oldDataMultiKey[i];
                    eventsPerStreamOneStream[0] = oldData[i];
                    this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                    result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStreamOneStream, false, this.agentInstanceContext);
                    if (result == null || !result.booleanValue() || !(pass = (outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory())).updateOutputCondition(0, 1)) || groupRepsView.put(mk, eventsPerStream = new EventBean[]{oldData[i]}) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
            }
        }
        this.generateOutputBatchedArr(false, groupRepsView.entrySet().iterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        Object var9_12 = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray2 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] objectArray = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, objectArray, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                void var9_14;
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_14, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && var9_16 == null) {
            return null;
        }
        return new UniformPair<void>((void)newEventsArr, var9_16);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewAll(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        EventBean[] eventsPerStream = new EventBean[1];
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        if (this.prototype.isSelectRStream()) {
            this.generateOutputBatchedArr(false, this.outputAllGroupReps.entryIterator(), false, generateSynthetic, oldEvents, oldEventsSortKey);
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            Object mk;
            int n;
            int n2;
            EventBean[] eventBeanArray;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                eventBeanArray = newData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = eventBeanArray[n];
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (this.outputAllGroupReps.put(mk, new EventBean[]{aNewData}) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            eventBeanArray = oldData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                EventBean anOldData;
                eventsPerStream[0] = anOldData = eventBeanArray[n];
                mk = this.generateGroupKey(eventsPerStream, true);
                if (this.outputAllGroupReps.put(mk, new EventBean[]{anOldData}) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedRow(false, mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(false, this.outputAllGroupReps.entryIterator(), true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewDefault(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        HashMap<Object, EventBean> keysAndEvents = new HashMap<Object, EventBean>();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int n;
            int n2;
            EventBean[] eventBeanArray;
            int count;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedRow(keysAndEvents, false, generateSynthetic, oldEvents, oldEventsSortKey, this.agentInstanceContext);
            }
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                count = 0;
                eventBeanArray = newData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean aNewData;
                    eventsPerStream[0] = aNewData = eventBeanArray[n];
                    this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                eventBeanArray = oldData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = eventBeanArray[n];
                    this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            this.generateOutputBatchedRow(keysAndEvents, true, generateSynthetic, newEvents, newEventsSortKey, this.agentInstanceContext);
            keysAndEvents.clear();
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private Object[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        Object[] keys = new Object[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }
}

