/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResultSetProcessorUtil {
    public static void applyAggViewResult(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, EventBean[] newData, EventBean[] oldData, EventBean[] eventsPerStream) {
        int i;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                aggregationService.applyEnter(eventsPerStream, null, exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                aggregationService.applyLeave(eventsPerStream, null, exprEvaluatorContext);
            }
        }
    }

    public static void applyAggJoinResult(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> events : newEvents) {
                aggregationService.applyEnter(events.getArray(), null, exprEvaluatorContext);
            }
        }
        if (!oldEvents.isEmpty()) {
            for (MultiKey<EventBean> events : oldEvents) {
                aggregationService.applyLeave(events.getArray(), null, exprEvaluatorContext);
            }
        }
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[][] eventGenerators = new EventBean[events.length][];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            eventGenerators[i] = new EventBean[]{events[i]};
        }
        return orderByProcessor.sort(result, eventGenerators, isNewData, exprEvaluatorContext);
    }

    protected static EventBean[] getSelectEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        ArrayDeque<EventBean[]> eventGenerators = null;
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean generated;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (generated = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.length);
                eventGenerators = new ArrayDeque<EventBean[]>(events.length);
            }
            result.add(generated);
            eventGenerators.add(new EventBean[]{theEvent});
        }
        if (result != null) {
            return orderByProcessor.sort(result.toArray(new EventBean[result.size()]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[eventGenerators.size()][]), isNewData, exprEvaluatorContext);
        }
        return null;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean generated;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (generated = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.length);
            }
            result.add(generated);
        }
        if (result != null) {
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    protected static EventBean[] getSelectJoinEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        EventBean[] result = new EventBean[events.size()];
        EventBean[][] eventGenerators = new EventBean[events.size()][];
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            eventGenerators[count] = eventsPerStream;
            ++count;
        }
        return orderByProcessor.sort(result, eventGenerators, isNewData, exprEvaluatorContext);
    }

    protected static EventBean[] getSelectJoinEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        EventBean[] result = new EventBean[events.size()];
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            ++count;
        }
        return result;
    }

    protected static EventBean[] getSelectJoinEventsHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        for (MultiKey<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.size());
            }
            result.add(resultEvent);
        }
        if (result != null) {
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    protected static EventBean[] getSelectJoinEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        ArrayDeque<EventBean[]> eventGenerators = null;
        for (MultiKey<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.size());
                eventGenerators = new ArrayDeque<EventBean[]>(events.size());
            }
            result.add(resultEvent);
            eventGenerators.add(eventsPerStream);
        }
        if (result != null) {
            return orderByProcessor.sort(result.toArray(new EventBean[result.size()]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[eventGenerators.size()][]), isNewData, exprEvaluatorContext);
        }
        return null;
    }

    protected static void populateSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, Collection<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
        }
    }

    protected static void populateSelectEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, Collection<EventBean> result, List<Object> sortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
            sortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void populateSelectEventsHaving(SelectExprProcessor exprProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean resultEvent;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
        }
    }

    protected static void populateSelectEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean resultEvent;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void populateSelectJoinEventsHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
        }
    }

    protected static void populateSelectJoinEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> sortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)havingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue() || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
            sortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void populateSelectJoinEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        int length;
        int n = length = events != null ? events.size() : 0;
        if (length == 0) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
        }
    }

    protected static void populateSelectJoinEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        int length;
        int n = length = events != null ? events.size() : 0;
        if (length == 0) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    public static void clearAndAggregateUngrouped(ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService, Viewable parent) {
        aggregationService.clearResults(exprEvaluatorContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            aggregationService.applyEnter(eventsPerStream, null, exprEvaluatorContext);
        }
    }

    public static ArrayDeque<EventBean> iteratorToDeque(Iterator<EventBean> it) {
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>();
        while (it.hasNext()) {
            deque.add(it.next());
        }
        return deque;
    }
}

