/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.util.LevenshteinDistance;

public class StreamTypeServiceUtil {
    protected static Pair<Integer, String> findLevMatch(EventType[] eventTypes, String propertyName) {
        String bestMatch = null;
        int bestMatchDiff = Integer.MAX_VALUE;
        for (int i = 0; i < eventTypes.length; ++i) {
            if (eventTypes[i] == null) continue;
            EventPropertyDescriptor[] props = eventTypes[i].getPropertyDescriptors();
            for (int j = 0; j < props.length; ++j) {
                int diff = LevenshteinDistance.computeLevenshteinDistance(propertyName, props[j].getPropertyName());
                if (diff >= bestMatchDiff) continue;
                bestMatchDiff = diff;
                bestMatch = props[j].getPropertyName();
            }
        }
        if (bestMatchDiff < Integer.MAX_VALUE) {
            return new Pair<Integer, Object>(bestMatchDiff, bestMatch);
        }
        return null;
    }

    protected static Pair<Integer, String> findLevMatch(String propertyName, EventType eventType) {
        String bestMatch = null;
        int bestMatchDiff = Integer.MAX_VALUE;
        EventPropertyDescriptor[] props = eventType.getPropertyDescriptors();
        for (int j = 0; j < props.length; ++j) {
            int diff = LevenshteinDistance.computeLevenshteinDistance(propertyName, props[j].getPropertyName());
            if (diff >= bestMatchDiff) continue;
            bestMatchDiff = diff;
            bestMatch = props[j].getPropertyName();
        }
        if (bestMatchDiff < Integer.MAX_VALUE) {
            return new Pair<Integer, Object>(bestMatchDiff, bestMatch);
        }
        return null;
    }
}

