/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusMinus;
import com.espertech.esper.epl.datetime.calop.CalendarOpRound;
import com.espertech.esper.epl.datetime.calop.CalendarOpSet;
import com.espertech.esper.epl.datetime.calop.CalendarOpUtil;
import com.espertech.esper.epl.datetime.calop.CalendarOpWithDate;
import com.espertech.esper.epl.datetime.calop.CalendarOpWithMax;
import com.espertech.esper.epl.datetime.calop.CalendarOpWithMin;
import com.espertech.esper.epl.datetime.calop.CalendarOpWithTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.OpFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import java.util.List;

public class CalendarOpFactory
implements OpFactory {
    public CalendarOp getOp(DatetimeMethodEnum method, String methodNameUsed, List<ExprNode> parameters, ExprEvaluator[] evaluators) throws ExprValidationException {
        if (method == DatetimeMethodEnum.WITHTIME) {
            return new CalendarOpWithTime(evaluators[0], evaluators[1], evaluators[2], evaluators[3]);
        }
        if (method == DatetimeMethodEnum.WITHDATE) {
            return new CalendarOpWithDate(evaluators[0], evaluators[1], evaluators[2]);
        }
        if (method == DatetimeMethodEnum.PLUS || method == DatetimeMethodEnum.MINUS) {
            return new CalendarOpPlusMinus(evaluators[0], method == DatetimeMethodEnum.MINUS ? -1 : 1);
        }
        if (method == DatetimeMethodEnum.WITHMAX || method == DatetimeMethodEnum.WITHMIN || method == DatetimeMethodEnum.ROUNDCEILING || method == DatetimeMethodEnum.ROUNDFLOOR || method == DatetimeMethodEnum.ROUNDHALF || method == DatetimeMethodEnum.SET) {
            CalendarFieldEnum fieldNum = CalendarOpUtil.getEnum(methodNameUsed, parameters.get(0));
            if (method == DatetimeMethodEnum.WITHMIN) {
                return new CalendarOpWithMin(fieldNum);
            }
            if (method == DatetimeMethodEnum.ROUNDCEILING || method == DatetimeMethodEnum.ROUNDFLOOR || method == DatetimeMethodEnum.ROUNDHALF) {
                return new CalendarOpRound(fieldNum, method);
            }
            if (method == DatetimeMethodEnum.SET) {
                return new CalendarOpSet(fieldNum, evaluators[1]);
            }
            return new CalendarOpWithMax(fieldNum);
        }
        throw new IllegalStateException("Unrecognized calendar-op code '" + (Object)((Object)method) + "'");
    }
}

