/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusFastAddResult;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusMinus;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarOpPlusFastAddHelper {
    private static final boolean DEBUG = false;
    private static Logger log = LoggerFactory.getLogger(CalendarOpPlusFastAddHelper.class);

    public static CalendarOpPlusFastAddResult computeNextDue(long currentTime, TimePeriod timePeriod, Calendar reference, TimeAbacus timeAbacus, long remainder) {
        long multiplierRoundedLong;
        if (timeAbacus.calendarGet(reference, remainder) > currentTime) {
            return new CalendarOpPlusFastAddResult(0L, reference);
        }
        Calendar work = (Calendar)reference.clone();
        CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
        long inMillis = timeAbacus.calendarGet(work, remainder);
        if (inMillis > currentTime) {
            return new CalendarOpPlusFastAddResult(1L, work);
        }
        long factor = 1L;
        long refTime = timeAbacus.calendarGet(reference, remainder);
        long deltaCurrentToStart = currentTime - refTime;
        long deltaAddedOne = timeAbacus.calendarGet(work, remainder) - refTime;
        double multiplierDbl = deltaCurrentToStart / deltaAddedOne - 1L;
        for (multiplierRoundedLong = (long)multiplierDbl; multiplierRoundedLong > Integer.MAX_VALUE; multiplierRoundedLong -= Integer.MAX_VALUE) {
            CalendarOpPlusMinus.actionSafeOverflow(work, Integer.MAX_VALUE, timePeriod);
            factor += Integer.MAX_VALUE;
        }
        int multiplierRoundedInt = (int)multiplierRoundedLong;
        CalendarOpPlusMinus.actionSafeOverflow(work, multiplierRoundedInt, timePeriod);
        factor += (long)multiplierRoundedInt;
        if (timeAbacus.calendarGet(work, remainder) <= currentTime) {
            while (timeAbacus.calendarGet(work, remainder) <= currentTime) {
                CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
                ++factor;
            }
            return new CalendarOpPlusFastAddResult(factor, work);
        }
        while (timeAbacus.calendarGet(work, remainder) > currentTime) {
            CalendarOpPlusMinus.actionSafeOverflow(work, -1, timePeriod);
            --factor;
        }
        CalendarOpPlusMinus.actionSafeOverflow(work, 1, timePeriod);
        return new CalendarOpPlusFastAddResult(factor + 1L, work);
    }
}

