/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ValueRange;
import java.util.Calendar;

public class CalendarOpWithMax
implements CalendarOp {
    private final CalendarFieldEnum fieldName;

    public CalendarOpWithMax(CalendarFieldEnum fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        cal.set(this.fieldName.getCalendarField(), cal.getActualMaximum(this.fieldName.getCalendarField()));
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = ldt.range(this.fieldName.getChronoField());
        return ldt.with(this.fieldName.getChronoField(), range.getMaximum());
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ValueRange range = zdt.range(this.fieldName.getChronoField());
        return zdt.with(this.fieldName.getChronoField(), range.getMaximum());
    }
}

