/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.calop.CalendarOpFactory;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDT;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDTMethodDesc;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.datetime.eval.OpFactory;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.datetime.interval.IntervalOpFactory;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.datetime.reformatop.ReformatOpFactory;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.epl.methodbase.DotMethodInputTypeMatcher;
import com.espertech.esper.epl.methodbase.DotMethodTypeEnum;
import com.espertech.esper.epl.methodbase.DotMethodUtil;
import com.espertech.esper.epl.rettype.ClassEPType;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.rettype.EventEPType;
import com.espertech.esper.epl.rettype.NullEPType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.TimeZone;

public class ExprDotEvalDTFactory {
    public static ExprDotEvalDTMethodDesc validateMake(StreamTypeService streamTypeService, Deque<ExprChainedSpec> chainSpecStack, DatetimeMethodEnum dtMethod, String dtMethodName, EPType inputType, List<ExprNode> parameters, ExprDotNodeFilterAnalyzerInput inputDesc, TimeZone timeZone, TimeAbacus timeAbacus) throws ExprValidationException {
        ExprDotNodeFilterAnalyzerDesc filterAnalyzerDesc;
        IntervalOp intervalOp;
        ReformatOp reformatOp;
        ArrayList<CalendarOp> calendarOps;
        block12: {
            ExprChainedSpec next;
            String message = "Date-time enumeration method '" + dtMethodName + "' requires either a Calendar, Date, long, LocalDateTime or ZonedDateTime value as input or events of an event type that declares a timestamp property";
            if (inputType instanceof EventEPType) {
                if (((EventEPType)inputType).getType().getStartTimestampPropertyName() == null) {
                    throw new ExprValidationException(message);
                }
            } else {
                ClassEPType classEPType;
                if (!(inputType instanceof ClassEPType) && !(inputType instanceof NullEPType)) {
                    throw new ExprValidationException(message + " but received " + EPTypeHelper.toTypeDescriptive(inputType));
                }
                if (inputType instanceof ClassEPType && !JavaClassHelper.isDatetimeClass((classEPType = (ClassEPType)inputType).getType())) {
                    throw new ExprValidationException(message + " but received " + JavaClassHelper.getClassNameFullyQualPretty(classEPType.getType()));
                }
            }
            calendarOps = new ArrayList<CalendarOp>();
            reformatOp = null;
            intervalOp = null;
            DatetimeMethodEnum currentMethod = dtMethod;
            List<ExprNode> currentParameters = parameters;
            String currentMethodName = dtMethodName;
            filterAnalyzerDesc = null;
            do {
                ExprEvaluator[] evaluators = ExprDotEvalDTFactory.getEvaluators(currentParameters);
                OpFactory opFactory = currentMethod.getOpFactory();
                DotMethodFPProvided footprintProvided = DotMethodUtil.getProvidedFootprint(currentParameters);
                DotMethodUtil.validateParametersDetermineFootprint(currentMethod.getFootprints(), DotMethodTypeEnum.DATETIME, currentMethodName, footprintProvided, DotMethodInputTypeMatcher.DEFAULT_ALL);
                if (opFactory instanceof CalendarOpFactory) {
                    CalendarOp calendarOp = ((CalendarOpFactory)currentMethod.getOpFactory()).getOp(currentMethod, currentMethodName, currentParameters, evaluators);
                    calendarOps.add(calendarOp);
                } else if (opFactory instanceof ReformatOpFactory) {
                    reformatOp = ((ReformatOpFactory)opFactory).getOp(timeZone, timeAbacus, currentMethod, currentMethodName, currentParameters);
                    filterAnalyzerDesc = calendarOps.isEmpty() ? reformatOp.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else if (opFactory instanceof IntervalOpFactory) {
                    intervalOp = ((IntervalOpFactory)opFactory).getOp(streamTypeService, currentMethod, currentMethodName, currentParameters, timeZone, timeAbacus);
                    filterAnalyzerDesc = calendarOps.isEmpty() ? intervalOp.getFilterDesc(streamTypeService.getEventTypes(), currentMethod, currentParameters, inputDesc) : null;
                } else {
                    throw new IllegalStateException("Invalid op factory class " + opFactory);
                }
                if (chainSpecStack.isEmpty() || !DatetimeMethodEnum.isDateTimeMethod(chainSpecStack.getFirst().getName())) break block12;
                next = chainSpecStack.removeFirst();
                currentMethod = DatetimeMethodEnum.fromName(next.getName());
                currentParameters = next.getParameters();
                currentMethodName = next.getName();
            } while (reformatOp == null && intervalOp == null);
            throw new ExprValidationException("Invalid input for date-time method '" + next.getName() + "'");
        }
        ExprDotEvalDT dotEval = new ExprDotEvalDT(calendarOps, timeZone, timeAbacus, reformatOp, intervalOp, EPTypeHelper.getClassSingleValued(inputType), EPTypeHelper.getEventTypeSingleValued(inputType));
        EPType returnType = dotEval.getTypeInfo();
        return new ExprDotEvalDTMethodDesc(dotEval, returnType, filterAnalyzerDesc);
    }

    private static ExprEvaluator[] getEvaluators(List<ExprNode> parameters) {
        ExprEvaluator[] inputExpr = new ExprEvaluator[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            ExprNode innerExpr = parameters.get(i);
            ExprEvaluator inner = innerExpr.getExprEvaluator();
            if (innerExpr instanceof ExprTimePeriod) {
                final ExprTimePeriod timePeriod = (ExprTimePeriod)innerExpr;
                inputExpr[i] = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                        return timePeriod.evaluateGetTimePeriod(eventsPerStream, isNewData, context);
                    }

                    @Override
                    public Class getType() {
                        return TimePeriod.class;
                    }
                };
                continue;
            }
            inputExpr[i] = inner;
        }
        return inputExpr;
    }
}

