/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.db.ColumnSettings;
import com.espertech.esper.epl.db.ConnectionCache;
import com.espertech.esper.epl.db.ConnectionCacheImpl;
import com.espertech.esper.epl.db.ConnectionNoCacheImpl;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheFactory;
import com.espertech.esper.epl.db.DatabaseConfigException;
import com.espertech.esper.epl.db.DatabaseConfigService;
import com.espertech.esper.epl.db.DatabaseConnectionFactory;
import com.espertech.esper.epl.db.DatabaseDMConnFactory;
import com.espertech.esper.epl.db.DatabaseDSConnFactory;
import com.espertech.esper.epl.db.DatabaseDSFactoryConnFactory;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfigServiceImpl
implements DatabaseConfigService {
    private final Map<String, ConfigurationDBRef> mapDatabaseRef;
    private final Map<String, DatabaseConnectionFactory> connectionFactories;
    private final SchedulingService schedulingService;
    private final ScheduleBucket scheduleBucket;
    private final EngineImportService engineImportService;

    public DatabaseConfigServiceImpl(Map<String, ConfigurationDBRef> mapDatabaseRef, SchedulingService schedulingService, ScheduleBucket scheduleBucket, EngineImportService engineImportService) {
        this.mapDatabaseRef = mapDatabaseRef;
        this.connectionFactories = new HashMap<String, DatabaseConnectionFactory>();
        this.schedulingService = schedulingService;
        this.scheduleBucket = scheduleBucket;
        this.engineImportService = engineImportService;
    }

    @Override
    public ConnectionCache getConnectionCache(String databaseName, String preparedStatementText) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        DatabaseConnectionFactory connectionFactory = this.getConnectionFactory(databaseName);
        boolean retain = config.getConnectionLifecycleEnum().equals((Object)ConfigurationDBRef.ConnectionLifecycleEnum.RETAIN);
        if (retain) {
            return new ConnectionCacheImpl(connectionFactory, preparedStatementText);
        }
        return new ConnectionNoCacheImpl(connectionFactory, preparedStatementText);
    }

    @Override
    public DatabaseConnectionFactory getConnectionFactory(String databaseName) throws DatabaseConfigException {
        DatabaseConnectionFactory factory = this.connectionFactories.get(databaseName);
        if (factory != null) {
            return factory;
        }
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        ConfigurationDBRef.ConnectionSettings settings = config.getConnectionSettings();
        if (config.getConnectionFactoryDesc() instanceof ConfigurationDBRef.DriverManagerConnection) {
            ConfigurationDBRef.DriverManagerConnection dmConfig = (ConfigurationDBRef.DriverManagerConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDMConnFactory(dmConfig, settings, this.engineImportService);
        } else if (config.getConnectionFactoryDesc() instanceof ConfigurationDBRef.DataSourceConnection) {
            ConfigurationDBRef.DataSourceConnection dsConfig = (ConfigurationDBRef.DataSourceConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDSConnFactory(dsConfig, settings);
        } else if (config.getConnectionFactoryDesc() instanceof ConfigurationDBRef.DataSourceFactory) {
            ConfigurationDBRef.DataSourceFactory dsConfig = (ConfigurationDBRef.DataSourceFactory)config.getConnectionFactoryDesc();
            factory = new DatabaseDSFactoryConnFactory(dsConfig, settings, this.engineImportService);
        } else {
            if (config.getConnectionFactoryDesc() == null) {
                throw new DatabaseConfigException("No connection factory setting provided in configuration");
            }
            throw new DatabaseConfigException("Unknown connection factory setting provided in configuration");
        }
        this.connectionFactories.put(databaseName, factory);
        return factory;
    }

    @Override
    public DataCache getDataCache(String databaseName, StatementContext statementContext, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, DataCacheFactory dataCacheFactory, int streamNumber) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        ConfigurationDataCache dataCacheDesc = config.getDataCacheDesc();
        return dataCacheFactory.getDataCache(dataCacheDesc, statementContext, epStatementAgentInstanceHandle, this.schedulingService, this.scheduleBucket, streamNumber);
    }

    @Override
    public ColumnSettings getQuerySetting(String databaseName) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        return new ColumnSettings(config.getMetadataRetrievalEnum(), config.getColumnChangeCase(), config.getSqlTypesMapping());
    }
}

