/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.declexpr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.core.service.ExpressionResultCacheForDeclaredExprLastColl;
import com.espertech.esper.core.service.ExpressionResultCacheForDeclaredExprLastValue;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.event.EventAdapterService;
import java.util.Collection;
import java.util.LinkedHashMap;

public abstract class ExprDeclaredEvalBase
implements ExprEvaluatorTypableReturn,
ExprEvaluatorEnumeration {
    private final ExprEvaluator innerEvaluator;
    private final ExprEvaluatorEnumeration innerEvaluatorLambda;
    private final ExpressionDeclItem prototype;
    private final boolean isCache;

    public abstract EventBean[] getEventsPerStreamRewritten(EventBean[] var1);

    public ExprDeclaredEvalBase(ExprEvaluator innerEvaluator, ExpressionDeclItem prototype, boolean isCache) {
        this.innerEvaluator = innerEvaluator;
        this.prototype = prototype;
        this.innerEvaluatorLambda = innerEvaluator instanceof ExprEvaluatorEnumeration ? (ExprEvaluatorEnumeration)((Object)innerEvaluator) : null;
        this.isCache = isCache;
    }

    public ExprEvaluator getInnerEvaluator() {
        return this.innerEvaluator;
    }

    @Override
    public Class getType() {
        return this.innerEvaluator.getType();
    }

    @Override
    public LinkedHashMap<String, Object> getRowProperties() throws ExprValidationException {
        if (this.innerEvaluator instanceof ExprEvaluatorTypableReturn) {
            return ((ExprEvaluatorTypableReturn)this.innerEvaluator).getRowProperties();
        }
        return null;
    }

    @Override
    public Boolean isMultirow() {
        if (this.innerEvaluator instanceof ExprEvaluatorTypableReturn) {
            return ((ExprEvaluatorTypableReturn)this.innerEvaluator).isMultirow();
        }
        return null;
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return ((ExprEvaluatorTypableReturn)this.innerEvaluator).evaluateTypableSingle(eventsPerStream, isNewData, context);
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return ((ExprEvaluatorTypableReturn)this.innerEvaluator).evaluateTypableMulti(eventsPerStream, isNewData, context);
    }

    @Override
    public final Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result;
        EventBean[] events = this.getEventsPerStreamRewritten(eventsPerStream);
        if (this.isCache) {
            ExpressionResultCacheForDeclaredExprLastValue cache = context.getExpressionResultCacheService().getAllocateDeclaredExprLastValue();
            ExpressionResultCacheEntry<EventBean[], Object> entry = cache.getDeclaredExpressionLastValue(this.prototype, events);
            if (entry != null) {
                return entry.getResult();
            }
            result = this.innerEvaluator.evaluate(events, isNewData, context);
            cache.saveDeclaredExpressionLastValue(this.prototype, events, result);
        } else {
            result = this.innerEvaluator.evaluate(events, isNewData, context);
        }
        return result;
    }

    @Override
    public final Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean[] events = this.getEventsPerStreamRewritten(eventsPerStream);
        if (this.isCache) {
            ExpressionResultCacheForDeclaredExprLastColl cache = context.getExpressionResultCacheService().getAllocateDeclaredExprLastColl();
            ExpressionResultCacheEntry<EventBean[], Collection<EventBean>> entry = cache.getDeclaredExpressionLastColl(this.prototype, events);
            if (entry != null) {
                return entry.getResult();
            }
            Collection<EventBean> result = this.innerEvaluatorLambda.evaluateGetROCollectionEvents(events, isNewData, context);
            cache.saveDeclaredExpressionLastColl(this.prototype, events, result);
            return result;
        }
        Collection<EventBean> result = this.innerEvaluatorLambda.evaluateGetROCollectionEvents(events, isNewData, context);
        return result;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean[] events = this.getEventsPerStreamRewritten(eventsPerStream);
        if (this.isCache) {
            ExpressionResultCacheForDeclaredExprLastColl cache = context.getExpressionResultCacheService().getAllocateDeclaredExprLastColl();
            ExpressionResultCacheEntry<EventBean[], Collection<EventBean>> entry = cache.getDeclaredExpressionLastColl(this.prototype, events);
            if (entry != null) {
                return entry.getResult();
            }
            Collection result = this.innerEvaluatorLambda.evaluateGetROCollectionScalar(events, isNewData, context);
            cache.saveDeclaredExpressionLastColl(this.prototype, events, result);
            return result;
        }
        Collection result = this.innerEvaluatorLambda.evaluateGetROCollectionScalar(events, isNewData, context);
        return result;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        if (this.innerEvaluatorLambda != null) {
            return this.innerEvaluatorLambda.getComponentTypeCollection();
        }
        return null;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.innerEvaluatorLambda != null) {
            return this.innerEvaluatorLambda.getEventTypeCollection(eventAdapterService, statementId);
        }
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.innerEvaluatorLambda != null) {
            return this.innerEvaluatorLambda.getEventTypeSingle(eventAdapterService, statementId);
        }
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.innerEvaluatorLambda.evaluateGetEventBean(eventsPerStream, isNewData, context);
    }
}

