/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.declexpr;

import com.espertech.esper.epl.declexpr.ExprDeclaredService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.CreateExpressionDesc;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExprDeclaredServiceImpl
implements ExprDeclaredService {
    private final Map<String, ExpressionDeclItem> globalExpressions = new HashMap<String, ExpressionDeclItem>();
    private final Map<String, List<ExpressionScriptProvided>> globalScripts = new HashMap<String, List<ExpressionScriptProvided>>();

    @Override
    public synchronized String addExpressionOrScript(CreateExpressionDesc expressionDesc) throws ExprValidationException {
        if (expressionDesc.getExpression() != null) {
            ExpressionDeclItem expression = expressionDesc.getExpression();
            String name = expression.getName();
            if (this.globalExpressions.containsKey(name)) {
                throw new ExprValidationException("Expression '" + name + "' has already been declared");
            }
            this.globalExpressions.put(name, expression);
            return name;
        }
        ExpressionScriptProvided newScript = expressionDesc.getScript();
        String name = newScript.getName();
        List<ExpressionScriptProvided> scripts = this.globalScripts.get(name);
        if (scripts != null) {
            for (ExpressionScriptProvided script : scripts) {
                if (script.getParameterNames().size() != newScript.getParameterNames().size()) continue;
                throw new ExprValidationException("Script '" + name + "' that takes the same number of parameters has already been declared");
            }
        } else {
            scripts = new ArrayList<ExpressionScriptProvided>(2);
            this.globalScripts.put(name, scripts);
        }
        scripts.add(newScript);
        return name;
    }

    @Override
    public ExpressionDeclItem getExpression(String name) {
        return this.globalExpressions.get(name);
    }

    @Override
    public List<ExpressionScriptProvided> getScriptsByName(String name) {
        return this.globalScripts.get(name);
    }

    @Override
    public synchronized void destroyedExpression(CreateExpressionDesc expressionDesc) {
        if (expressionDesc.getExpression() != null) {
            this.globalExpressions.remove(expressionDesc.getExpression().getName());
        } else {
            this.globalScripts.remove(expressionDesc.getScript().getName());
        }
    }

    @Override
    public void destroy() {
        this.globalExpressions.clear();
    }
}

