/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.epl.enummethod.dot.ArrayWrappingCollection;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotStaticMethodWrapArrayScalar
implements ExprDotStaticMethodWrap {
    private static final Logger log = LoggerFactory.getLogger(ExprDotStaticMethodWrapArrayScalar.class);
    private final String methodName;
    private final Class componentType;

    public ExprDotStaticMethodWrapArrayScalar(String methodName, Class componentType) {
        this.methodName = methodName;
        this.componentType = componentType;
    }

    @Override
    public EPType getTypeInfo() {
        return EPTypeHelper.collectionOfSingleValue(this.componentType);
    }

    @Override
    public Collection convert(Object result) {
        if (result == null) {
            return null;
        }
        if (!result.getClass().isArray()) {
            log.warn("Expected array-type input from method '" + this.methodName + "' but received " + result.getClass());
            return null;
        }
        return new ArrayWrappingCollection(result);
    }
}

