/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.CountMinSketchAgent;
import com.espertech.esper.client.util.CountMinSketchAgentStringUTF16;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.factory.AggregationStateFactoryCountMinSketch;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.approx.CountMinSketchAggType;
import com.espertech.esper.epl.approx.CountMinSketchSpec;
import com.espertech.esper.epl.approx.CountMinSketchSpecHashes;
import com.espertech.esper.epl.expression.accessagg.ExprAggCountMinSketchNodeFactoryState;
import com.espertech.esper.epl.expression.accessagg.ExprAggCountMinSketchNodeFactoryUse;
import com.espertech.esper.epl.expression.accessagg.ExprAggregateAccessMultiValueNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.PopulateFieldValueSetter;
import com.espertech.esper.util.PopulateFieldWValueDescriptor;
import com.espertech.esper.util.PopulateUtil;
import java.util.Collection;
import java.util.Map;

public class ExprAggCountMinSketchNode
extends ExprAggregateNodeBase
implements ExprAggregateAccessMultiValueNode {
    private static final long serialVersionUID = 202339518989532184L;
    private static final double DEFAULT_EPS_OF_TOTAL_COUNT = 1.0E-4;
    private static final double DEFAULT_CONFIDENCE = 0.99;
    private static final int DEFAULT_SEED = 1234567;
    private static final CountMinSketchAgentStringUTF16 DEFAULT_AGENT = new CountMinSketchAgentStringUTF16();
    private static final String MSG_NAME = "Count-min-sketch";
    private static final String NAME_EPS_OF_TOTAL_COUNT = "epsOfTotalCount";
    private static final String NAME_CONFIDENCE = "confidence";
    private static final String NAME_SEED = "seed";
    private static final String NAME_TOPK = "topk";
    private static final String NAME_AGENT = "agent";
    private final CountMinSketchAggType aggType;

    public ExprAggCountMinSketchNode(boolean distinct, CountMinSketchAggType aggType) {
        super(distinct);
        this.aggType = aggType;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, null);
    }

    @Override
    public AggregationMethodFactory validateAggregationParamsWBinding(ExprValidationContext context, TableMetadataColumnAggregation tableAccessColumn) throws ExprValidationException {
        return this.validateAggregationInternal(context, tableAccessColumn);
    }

    @Override
    public String getAggregationFunctionName() {
        return this.aggType.getFuncName();
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return false;
    }

    public CountMinSketchAggType getAggType() {
        return this.aggType;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    protected boolean isExprTextWildcardWhenNoParams() {
        return false;
    }

    private AggregationMethodFactory validateAggregationInternal(ExprValidationContext context, TableMetadataColumnAggregation tableAccessColumn) throws ExprValidationException {
        if (this.isDistinct()) {
            throw new ExprValidationException(this.getMessagePrefix() + "is not supported with distinct");
        }
        if (this.aggType == CountMinSketchAggType.STATE) {
            if (context.getExprEvaluatorContext().getStatementType() != StatementType.CREATE_TABLE) {
                throw new ExprValidationException(this.getMessagePrefix() + "can only be used in create-table statements");
            }
            CountMinSketchSpec specification = this.validateSpecification(context);
            AggregationStateFactoryCountMinSketch stateFactory = context.getEngineImportService().getAggregationFactoryFactory().makeCountMinSketch(context.getStatementExtensionSvcContext(), this, specification);
            return new ExprAggCountMinSketchNodeFactoryState(stateFactory);
        }
        if (this.aggType == CountMinSketchAggType.ADD || this.aggType == CountMinSketchAggType.FREQ) {
            if (this.getChildNodes().length == 0 || this.getChildNodes().length > 1) {
                throw new ExprValidationException(this.getMessagePrefix() + "requires a single parameter expression");
            }
        } else if (this.getChildNodes().length != 0) {
            throw new ExprValidationException(this.getMessagePrefix() + "requires a no parameter expressions");
        }
        if (this.aggType == CountMinSketchAggType.ADD) {
            if (context.getIntoTableName() == null) {
                throw new ExprValidationException(this.getMessagePrefix() + "can only be used with into-table");
            }
        } else {
            if (tableAccessColumn == null) {
                throw new ExprValidationException(this.getMessagePrefix() + "requires the use of a table-access expression");
            }
            ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, this.getChildNodes(), context);
        }
        ExprEvaluator addOrFrequencyEvaluator = null;
        if (this.aggType == CountMinSketchAggType.ADD || this.aggType == CountMinSketchAggType.FREQ) {
            addOrFrequencyEvaluator = this.getChildNodes()[0].getExprEvaluator();
        }
        return new ExprAggCountMinSketchNodeFactoryUse(this, addOrFrequencyEvaluator);
    }

    private CountMinSketchSpec validateSpecification(final ExprValidationContext exprValidationContext) throws ExprValidationException {
        final CountMinSketchSpec spec = new CountMinSketchSpec(new CountMinSketchSpecHashes(1.0E-4, 0.99, 1234567), null, DEFAULT_AGENT);
        if (this.getChildNodes().length == 0) {
            return spec;
        }
        if (this.getChildNodes().length > 1 || !(this.getChildNodes()[0] instanceof ExprConstantNode)) {
            throw this.getDeclaredWrongParameterExpr();
        }
        ExprConstantNode constantNode = (ExprConstantNode)this.getChildNodes()[0];
        Object value = constantNode.getConstantValue(exprValidationContext.getExprEvaluatorContext());
        if (!(value instanceof Map)) {
            throw this.getDeclaredWrongParameterExpr();
        }
        PopulateFieldWValueDescriptor[] descriptors = new PopulateFieldWValueDescriptor[]{new PopulateFieldWValueDescriptor(NAME_EPS_OF_TOTAL_COUNT, Double.class, spec.getHashesSpec().getClass(), new PopulateFieldValueSetter(){

            @Override
            public void set(Object value) {
                if (value != null) {
                    spec.getHashesSpec().setEpsOfTotalCount((Double)value);
                }
            }
        }, true), new PopulateFieldWValueDescriptor(NAME_CONFIDENCE, Double.class, spec.getHashesSpec().getClass(), new PopulateFieldValueSetter(){

            @Override
            public void set(Object value) {
                if (value != null) {
                    spec.getHashesSpec().setConfidence((Double)value);
                }
            }
        }, true), new PopulateFieldWValueDescriptor(NAME_SEED, Integer.class, spec.getHashesSpec().getClass(), new PopulateFieldValueSetter(){

            @Override
            public void set(Object value) {
                if (value != null) {
                    spec.getHashesSpec().setSeed((Integer)value);
                }
            }
        }, true), new PopulateFieldWValueDescriptor(NAME_TOPK, Integer.class, spec.getClass(), new PopulateFieldValueSetter(){

            @Override
            public void set(Object value) {
                if (value != null) {
                    spec.setTopkSpec((Integer)value);
                }
            }
        }, true), new PopulateFieldWValueDescriptor(NAME_AGENT, String.class, spec.getClass(), new PopulateFieldValueSetter(){

            @Override
            public void set(Object value) throws ExprValidationException {
                if (value != null) {
                    CountMinSketchAgent transform;
                    try {
                        Class transformClass = exprValidationContext.getEngineImportService().resolveClass((String)value, false);
                        transform = (CountMinSketchAgent)JavaClassHelper.instantiate(CountMinSketchAgent.class, transformClass);
                    }
                    catch (Exception e) {
                        throw new ExprValidationException("Failed to instantiate agent provider: " + e.getMessage(), e);
                    }
                    spec.setAgent(transform);
                }
            }
        }, true)};
        PopulateUtil.populateSpecCheckParameters(descriptors, (Map)value, spec, ExprNodeOrigin.AGGPARAM, exprValidationContext);
        return spec;
    }

    public ExprValidationException getDeclaredWrongParameterExpr() throws ExprValidationException {
        return new ExprValidationException(this.getMessagePrefix() + " expects either no parameter or a single json parameter object");
    }

    private String getMessagePrefix() {
        return "Count-min-sketch aggregation function '" + this.aggType.getFuncName() + "' ";
    }
}

