/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorImpl;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorLogging;
import com.espertech.esper.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.io.StringWriter;

public class ExprIdentNodeImpl
extends ExprNodeBase
implements ExprIdentNode {
    private static final long serialVersionUID = 5882493771230745244L;
    private final String unresolvedPropertyName;
    private String streamOrPropertyName;
    private String resolvedStreamName;
    private String resolvedPropertyName;
    private transient ExprIdentNodeEvaluator evaluator;

    public ExprIdentNodeImpl(String unresolvedPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = null;
    }

    public ExprIdentNodeImpl(String unresolvedPropertyName, String streamOrPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (streamOrPropertyName == null) {
            throw new IllegalArgumentException("Stream (or property name) name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public ExprIdentNodeImpl(EventType eventType, String propertyName, int streamNumber) {
        this.unresolvedPropertyName = propertyName;
        this.resolvedPropertyName = propertyName;
        EventPropertyGetter propertyGetter = eventType.getGetter(propertyName);
        if (propertyGetter == null) {
            throw new IllegalArgumentException("Ident-node constructor could not locate property " + propertyName);
        }
        Class propertyType = eventType.getPropertyType(propertyName);
        this.evaluator = new ExprIdentNodeEvaluatorImpl(streamNumber, propertyGetter, propertyType, this);
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    @Override
    public String getStreamOrPropertyName() {
        return this.streamOrPropertyName;
    }

    @Override
    public void setStreamOrPropertyName(String streamOrPropertyName) {
        this.streamOrPropertyName = streamOrPropertyName;
    }

    @Override
    public String getFullUnresolvedName() {
        if (this.streamOrPropertyName == null) {
            return this.unresolvedPropertyName;
        }
        return this.streamOrPropertyName + "." + this.unresolvedPropertyName;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return this.evaluator.getStreamNum() == 0 && !this.evaluator.isContextEvaluated();
    }

    @Override
    public FilterSpecLookupable getFilterLookupable() {
        return new FilterSpecLookupable(this.resolvedPropertyName, this.evaluator.getGetter(), this.evaluator.getType(), false);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EventPropertyGetter propertyGetter;
        ExprTableIdentNode tableIdentNode;
        if (validationContext.getStreamTypeService().hasTableTypes() && (tableIdentNode = validationContext.getTableService().getTableIdentNode(validationContext.getStreamTypeService(), this.unresolvedPropertyName, this.streamOrPropertyName)) != null) {
            return tableIdentNode;
        }
        String unescapedPropertyName = PropertyParser.unescapeBacktick(this.unresolvedPropertyName);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(validationContext.getStreamTypeService(), unescapedPropertyName, this.streamOrPropertyName, false);
        this.resolvedStreamName = propertyInfoPair.getSecond();
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        Class propertyType = propertyInfoPair.getFirst().getPropertyType();
        this.resolvedPropertyName = propertyInfoPair.getFirst().getPropertyName();
        try {
            propertyGetter = propertyInfoPair.getFirst().getStreamEventType().getGetter(this.resolvedPropertyName);
        }
        catch (PropertyAccessException ex) {
            throw new ExprValidationException("Property '" + this.unresolvedPropertyName + "' is not valid: " + ex.getMessage(), ex);
        }
        if (propertyGetter == null) {
            throw new ExprValidationException("Property getter returned was invalid for property '" + this.unresolvedPropertyName + "'");
        }
        Audit audit = AuditEnum.PROPERTY.getAudit(validationContext.getAnnotations());
        this.evaluator = audit != null ? new ExprIdentNodeEvaluatorLogging(streamNum, propertyGetter, propertyType, this, this.resolvedPropertyName, validationContext.getStatementName(), validationContext.getStreamTypeService().getEngineURIQualifier()) : new ExprIdentNodeEvaluatorImpl(streamNum, propertyGetter, propertyType, this);
        if (validationContext.getContextDescriptor() != null && !validationContext.isFilterExpression()) {
            EventType fromType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
            String contextPropertyName = validationContext.getContextDescriptor().getContextPropertyRegistry().getPartitionContextPropertyName(fromType, this.resolvedPropertyName);
            if (contextPropertyName != null) {
                EventType contextType = validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
                this.evaluator = new ExprIdentNodeEvaluatorContext(streamNum, contextType.getPropertyType(contextPropertyName), contextType.getGetter(contextPropertyName));
            }
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.evaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.evaluator.getStreamNum();
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        return this.getStreamId();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        return this.getResolvedPropertyNameRoot();
    }

    public Class getType() {
        if (this.evaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.evaluator.getType();
    }

    @Override
    public String getResolvedStreamName() {
        if (this.resolvedStreamName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedStreamName;
    }

    @Override
    public String getResolvedPropertyName() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedPropertyName;
    }

    @Override
    public String getResolvedPropertyNameRoot() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        if (this.resolvedPropertyName.indexOf(91) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(91));
        }
        if (this.resolvedPropertyName.indexOf(40) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(40));
        }
        if (this.resolvedPropertyName.indexOf(46) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(46));
        }
        return this.resolvedPropertyName;
    }

    public String toString() {
        return "unresolvedPropertyName=" + this.unresolvedPropertyName + " streamOrPropertyName=" + this.streamOrPropertyName + " resolvedPropertyName=" + this.resolvedPropertyName;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        ExprIdentNodeImpl.toPrecedenceFreeEPL(writer, this.streamOrPropertyName, this.unresolvedPropertyName);
    }

    public static void toPrecedenceFreeEPL(StringWriter writer, String streamOrPropertyName, String unresolvedPropertyName) {
        if (streamOrPropertyName != null) {
            writer.append(ASTUtil.unescapeDot(streamOrPropertyName)).append('.');
        }
        writer.append(ASTUtil.unescapeDot(PropertyParser.unescapeBacktick(unresolvedPropertyName)));
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprIdentNode)) {
            return false;
        }
        ExprIdentNode other = (ExprIdentNode)node;
        if (this.streamOrPropertyName != null ? !this.streamOrPropertyName.equals(other.getStreamOrPropertyName()) : other.getStreamOrPropertyName() != null) {
            return false;
        }
        return !(this.unresolvedPropertyName != null ? !this.unresolvedPropertyName.equals(other.getUnresolvedPropertyName()) : other.getUnresolvedPropertyName() != null);
    }

    @Override
    public ExprIdentNodeEvaluator getExprEvaluatorIdent() {
        return this.evaluator;
    }
}

