/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;

public class ExprIdentNodeUtil {
    public static Pair<PropertyResolutionDescriptor, String> getTypeFromStream(StreamTypeService streamTypeService, String propertyNameNestable, boolean explicitPropertiesOnly, boolean obtainFragment) throws ExprValidationPropertyException {
        String streamOrProp = null;
        String prop = propertyNameNestable;
        if (propertyNameNestable.indexOf(46) != -1) {
            prop = propertyNameNestable.substring(propertyNameNestable.indexOf(46) + 1);
            streamOrProp = propertyNameNestable.substring(0, propertyNameNestable.indexOf(46));
        }
        if (explicitPropertiesOnly) {
            return ExprIdentNodeUtil.getTypeFromStreamExplicitProperties(streamTypeService, prop, streamOrProp, obtainFragment);
        }
        return ExprIdentNodeUtil.getTypeFromStream(streamTypeService, prop, streamOrProp, obtainFragment);
    }

    protected static Pair<PropertyResolutionDescriptor, String> getTypeFromStream(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName, boolean obtainFragment) throws ExprValidationPropertyException {
        PropertyResolutionDescriptor propertyInfo = null;
        if (streamOrPropertyName == null) {
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(unresolvedPropertyName, obtainFragment);
            }
            catch (StreamTypesException ex) {
                throw ExprIdentNodeUtil.getSuggestionException(ex);
            }
            catch (PropertyAccessException ex) {
                throw new ExprValidationPropertyException("Failed to find property '" + unresolvedPropertyName + "', the property name does not parse (are you sure?): " + ex.getMessage(), ex);
            }
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, propertyInfo.getStreamName());
        }
        try {
            propertyInfo = streamTypeService.resolveByStreamAndPropName(streamOrPropertyName, unresolvedPropertyName, obtainFragment);
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
        }
        catch (StreamTypesException ex) {
            StreamTypesException typeExceptionOne = ex;
            String propertyNameCandidate = streamOrPropertyName + '.' + unresolvedPropertyName;
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(propertyNameCandidate, obtainFragment);
                return new Pair<PropertyResolutionDescriptor, Object>(propertyInfo, null);
            }
            catch (StreamTypesException ex2) {
                StreamTypesException typeExceptionTwo = ex2;
                if (streamTypeService.hasTableTypes() && streamOrPropertyName != null) {
                    for (int i = 0; i < streamTypeService.getEventTypes().length; ++i) {
                        EventType eventType = streamTypeService.getEventTypes()[i];
                        String tableName = TableServiceUtil.getTableNameFromEventType(eventType);
                        if (tableName == null || !tableName.equals(streamOrPropertyName)) continue;
                        try {
                            propertyInfo = streamTypeService.resolveByStreamAndPropName(eventType.getName(), unresolvedPropertyName, obtainFragment);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (propertyInfo == null) continue;
                        return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
                    }
                }
                try {
                    EventPropertyDescriptor d2;
                    PropertyResolutionDescriptor desc = streamTypeService.resolveByPropertyName(streamOrPropertyName, false);
                    if (desc != null && (d2 = desc.getStreamEventType().getPropertyDescriptor(streamOrPropertyName)) != null) {
                        String text = null;
                        if (d2.isIndexed()) {
                            text = "an indexed property and requires an index or enumeration method to access values";
                        }
                        if (d2.isMapped()) {
                            text = "a mapped property and requires keyed access";
                        }
                        if (text != null) {
                            throw new ExprValidationPropertyException("Failed to resolve property '" + propertyNameCandidate + "' (property '" + streamOrPropertyName + "' is " + text + ")");
                        }
                    }
                }
                catch (StreamTypesException streamTypesException) {
                    // empty catch block
                }
                throw ExprIdentNodeUtil.getSuggestionExceptionSecondStep(propertyNameCandidate, typeExceptionOne, typeExceptionTwo);
            }
        }
    }

    protected static Pair<PropertyResolutionDescriptor, String> getTypeFromStreamExplicitProperties(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName, boolean obtainFragment) throws ExprValidationPropertyException {
        if (streamOrPropertyName == null) {
            PropertyResolutionDescriptor propertyInfo;
            try {
                propertyInfo = streamTypeService.resolveByPropertyNameExplicitProps(unresolvedPropertyName, obtainFragment);
            }
            catch (StreamTypesException ex) {
                throw ExprIdentNodeUtil.getSuggestionException(ex);
            }
            catch (PropertyAccessException ex) {
                throw new ExprValidationPropertyException(ex.getMessage());
            }
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, propertyInfo.getStreamName());
        }
        try {
            PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByStreamAndPropNameExplicitProps(streamOrPropertyName, unresolvedPropertyName, obtainFragment);
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
        }
        catch (StreamTypesException ex) {
            StreamTypesException typeExceptionOne = ex;
            String propertyNameCandidate = streamOrPropertyName + '.' + unresolvedPropertyName;
            try {
                PropertyResolutionDescriptor propertyInfo = streamTypeService.resolveByPropertyNameExplicitProps(propertyNameCandidate, obtainFragment);
                return new Pair<PropertyResolutionDescriptor, Object>(propertyInfo, null);
            }
            catch (StreamTypesException ex2) {
                StreamTypesException typeExceptionTwo = ex2;
                throw ExprIdentNodeUtil.getSuggestionExceptionSecondStep(propertyNameCandidate, typeExceptionOne, typeExceptionTwo);
            }
        }
    }

    private static ExprValidationPropertyException getSuggestionExceptionSecondStep(String propertyNameCandidate, StreamTypesException typeExceptionOne, StreamTypesException typeExceptionTwo) {
        String suggestionOne = ExprIdentNodeUtil.getSuggestion(typeExceptionOne);
        String suggestionTwo = ExprIdentNodeUtil.getSuggestion(typeExceptionTwo);
        if (suggestionOne != null) {
            return new ExprValidationPropertyException(typeExceptionOne.getMessage() + suggestionOne);
        }
        if (suggestionTwo != null) {
            return new ExprValidationPropertyException(typeExceptionTwo.getMessage() + suggestionTwo);
        }
        return new ExprValidationPropertyException("Failed to resolve property '" + propertyNameCandidate + "' to a stream or nested property in a stream");
    }

    private static ExprValidationPropertyException getSuggestionException(StreamTypesException ex) {
        String suggestion = ExprIdentNodeUtil.getSuggestion(ex);
        if (suggestion != null) {
            return new ExprValidationPropertyException(ex.getMessage() + suggestion);
        }
        return new ExprValidationPropertyException(ex.getMessage());
    }

    private static String getSuggestion(StreamTypesException ex) {
        if (ex == null) {
            return null;
        }
        Pair<Integer, String> suggestion = ex.getOptionalSuggestion();
        if (suggestion == null) {
            return null;
        }
        if (suggestion.getFirst() > 3) {
            return null;
        }
        return " (did you mean '" + ex.getOptionalSuggestion().getSecond() + "'?)";
    }
}

