/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVisitor;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotEvalArrayGet
implements ExprDotEval {
    private static final Logger log = LoggerFactory.getLogger(ExprDotEvalArrayGet.class);
    private final EPType typeInfo;
    private final ExprEvaluator indexExpression;

    public ExprDotEvalArrayGet(ExprEvaluator index, Class componentType) {
        this.indexExpression = index;
        this.typeInfo = EPTypeHelper.singleValue(componentType);
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object index = this.indexExpression.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (index == null) {
            return null;
        }
        if (!(index instanceof Integer)) {
            return null;
        }
        int indexNum = (Integer)index;
        if (Array.getLength(target) <= indexNum) {
            return null;
        }
        return Array.get(target, indexNum);
    }

    @Override
    public EPType getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitArraySingleItemSource();
    }
}

