/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapArrayScalar;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambda;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaFragment;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaIndexed;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaMapped;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.epl.expression.core.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.epl.expression.dot.ExprDotEnumerationSource;
import com.espertech.esper.epl.expression.dot.ExprDotEnumerationSourceForProps;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalPropertyExprIndexed;
import com.espertech.esper.epl.expression.dot.ExprDotEvalPropertyExprMapped;
import com.espertech.esper.epl.expression.dot.ExprDotEvalRootChild;
import com.espertech.esper.epl.expression.dot.ExprDotEvalStaticMethod;
import com.espertech.esper.epl.expression.dot.ExprDotEvalStreamEventBean;
import com.espertech.esper.epl.expression.dot.ExprDotEvalStreamMethod;
import com.espertech.esper.epl.expression.dot.ExprDotEvalTransposeAsStream;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVariable;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputExpr;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.expression.dot.ExprDotNodeRealizedChain;
import com.espertech.esper.epl.expression.dot.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExprDotNodeImpl
extends ExprNodeBase
implements ExprDotNode,
ExprNodeInnerNodeProvider,
ExprStreamRefNode {
    private static final long serialVersionUID = 8105121208330622813L;
    private final List<ExprChainedSpec> chainSpec;
    private final boolean isDuckTyping;
    private final boolean isUDFCache;
    private transient ExprEvaluator exprEvaluator;
    private boolean isReturnsConstantResult;
    private transient ExprDotNodeFilterAnalyzerDesc exprDotNodeFilterAnalyzerDesc;
    private Integer streamNumReferenced;
    private String rootPropertyName;

    public ExprDotNodeImpl(List<ExprChainedSpec> chainSpec, boolean isDuckTyping, boolean isUDFCache) {
        this.chainSpec = new ArrayList<ExprChainedSpec>(chainSpec);
        this.isDuckTyping = isDuckTyping;
        this.isUDFCache = isUDFCache;
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        if (this.exprEvaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.streamNumReferenced;
    }

    @Override
    public String getRootPropertyNameIfAny() {
        if (this.exprEvaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.rootPropertyName;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilMethodDesc method;
        Pair<ExprNode, List<ExprChainedSpec>> tableNode;
        ExprNodeUtility.validate(ExprNodeOrigin.DOTNODEPARAMETER, this.chainSpec, validationContext);
        boolean hasEnumerationMethod = false;
        for (ExprChainedSpec chain : this.chainSpec) {
            if (!EnumMethodEnum.isEnumerationMethod(chain.getName())) continue;
            hasEnumerationMethod = true;
            break;
        }
        if (validationContext.getStreamTypeService().hasTableTypes() && validationContext.getTableService() != null && this.chainSpec.size() > 1 && this.chainSpec.get(0).isProperty() && (tableNode = validationContext.getTableService().getTableNodeChainable(validationContext.getStreamTypeService(), this.chainSpec, validationContext.getEngineImportService())) != null) {
            ExprNode node = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.DOTNODE, tableNode.getFirst(), validationContext);
            if (tableNode.getSecond().isEmpty()) {
                return node;
            }
            this.chainSpec.clear();
            this.chainSpec.addAll((Collection<ExprChainedSpec>)tableNode.getSecond());
            this.addChildNode(node);
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        if (this.getChildNodes().length != 0) {
            ExprNode rootNode = this.getChildNodes()[0];
            ExprEvaluator rootNodeEvaluator = rootNode.getExprEvaluator();
            ExprDotEnumerationSource enumSrc = ExprDotNodeUtility.getEnumerationSource(rootNode, validationContext.getStreamTypeService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), hasEnumerationMethod, validationContext.isDisablePropertyExpressionEventCollCache());
            EPType typeInfo = enumSrc.getReturnType() == null ? EPTypeHelper.singleValue(rootNodeEvaluator.getType()) : enumSrc.getReturnType();
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(enumSrc.getStreamOfProviderIfApplicable(), typeInfo, this.chainSpec, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputExpr());
            this.exprEvaluator = new ExprDotEvalRootChild(hasEnumerationMethod, this, rootNodeEvaluator, enumSrc.getEnumeration(), typeInfo, evals.getChain(), evals.getChainWithUnpack(), false);
            return null;
        }
        if (this.chainSpec.size() == 1) {
            ExprChainedSpec spec = this.chainSpec.get(0);
            if (spec.getParameters().isEmpty()) {
                throw this.handleNotFound(spec.getName());
            }
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, spec.getName(), streamTypeService.hasPropertyAgnosticType(), false);
            }
            catch (ExprValidationPropertyException enumSrc) {
                // empty catch block
            }
            if (propertyInfoPair == null && spec.getName().toLowerCase(Locale.ENGLISH).equals("transpose")) {
                if (spec.getParameters().size() != 1) {
                    throw new ExprValidationException("The transpose function requires a single parameter expression");
                }
                this.exprEvaluator = new ExprDotEvalTransposeAsStream(this.chainSpec.get(0).getParameters().get(0).getExprEvaluator());
            } else {
                if (spec.getParameters().size() != 1) {
                    throw this.handleNotFound(spec.getName());
                }
                if (propertyInfoPair == null) {
                    throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + spec.getName() + "' could not be resolved");
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(spec.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
                this.streamNumReferenced = propertyInfoPair.getFirst().getStreamNum();
            }
            return null;
        }
        ExprValidationException prefixedStreamNumException = null;
        int prefixedStreamNumber = this.prefixedStreamName(this.chainSpec, validationContext.getStreamTypeService());
        if (prefixedStreamNumber != -1) {
            ExprChainedSpec specAfterStreamName = this.chainSpec.get(1);
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                String propName = this.chainSpec.get(0).getName() + "." + specAfterStreamName.getName();
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, propName, streamTypeService.hasPropertyAgnosticType(), false);
            }
            catch (ExprValidationPropertyException propName) {
                // empty catch block
            }
            if (propertyInfoPair != null) {
                if (specAfterStreamName.getParameters().size() != 1) {
                    throw this.handleNotFound(specAfterStreamName.getName());
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(specAfterStreamName.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
                this.streamNumReferenced = propertyInfoPair.getFirst().getStreamNum();
                return null;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[prefixedStreamNumber];
            Class type = eventType.getUnderlyingType();
            ArrayList<ExprChainedSpec> remainderChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
            remainderChain.remove(0);
            ExprValidationException methodEx = null;
            ExprDotEval[] underlyingMethodChain = null;
            try {
                EPType typeInfo = EPTypeHelper.singleValue(type);
                underlyingMethodChain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber)).getChainWithUnpack();
            }
            catch (ExprValidationException ex) {
                methodEx = ex;
            }
            ExprDotEval[] eventTypeMethodChain = null;
            ExprValidationException enumDatetimeEx = null;
            try {
                EPType typeInfo = EPTypeHelper.singleEvent(eventType);
                ExprDotNodeRealizedChain chain = ExprDotNodeUtility.getChainEvaluators(prefixedStreamNumber, typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber));
                eventTypeMethodChain = chain.getChainWithUnpack();
                this.exprDotNodeFilterAnalyzerDesc = chain.getFilterAnalyzerDesc();
            }
            catch (ExprValidationException ex) {
                enumDatetimeEx = ex;
            }
            if (underlyingMethodChain != null) {
                this.exprEvaluator = new ExprDotEvalStreamMethod(this, prefixedStreamNumber, underlyingMethodChain);
                this.streamNumReferenced = prefixedStreamNumber;
            } else if (eventTypeMethodChain != null) {
                this.exprEvaluator = new ExprDotEvalStreamEventBean(this, prefixedStreamNumber, eventTypeMethodChain);
                this.streamNumReferenced = prefixedStreamNumber;
            }
            if (this.exprEvaluator != null) {
                return null;
            }
            prefixedStreamNumException = ExprDotNodeUtility.isDatetimeOrEnumMethod(((ExprChainedSpec)remainderChain.get(0)).getName()) ? enumDatetimeEx : new ExprValidationException("Failed to solve '" + ((ExprChainedSpec)remainderChain.get(0)).getName() + "' to either an date-time or enumeration method, an event property or a method on the event underlying object: " + methodEx.getMessage(), methodEx);
        }
        ArrayList<ExprChainedSpec> modifiedChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)modifiedChain.remove(0);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
        try {
            propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, firstItem.getName(), streamTypeService.hasPropertyAgnosticType(), true);
        }
        catch (ExprValidationPropertyException type) {
            // empty catch block
        }
        if (propertyInfoPair != null) {
            ExprDotNodeRealizedChain evals;
            EPType inputType;
            EPType typeInfo;
            EventPropertyGetter getter;
            String propertyName = ((PropertyResolutionDescriptor)propertyInfoPair.getFirst()).getPropertyName();
            int streamId = propertyInfoPair.getFirst().getStreamNum();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            ExprEvaluatorEnumeration enumerationEval = null;
            ExprEvaluator rootNodeEvaluator = null;
            if (firstItem.getParameters().isEmpty()) {
                getter = streamType.getGetter(propertyInfoPair.getFirst().getPropertyName());
                ExprDotEnumerationSourceForProps propertyEval = ExprDotNodeUtility.getPropertyEnumerationSource(propertyInfoPair.getFirst().getPropertyName(), streamId, streamType, hasEnumerationMethod, validationContext.isDisablePropertyExpressionEventCollCache());
                typeInfo = propertyEval.getReturnType();
                enumerationEval = propertyEval.getEnumeration();
                inputType = propertyEval.getReturnType();
                rootNodeEvaluator = new PropertyExprEvaluatorNonLambda(streamId, getter, propertyInfoPair.getFirst().getPropertyType());
            } else {
                EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamTypeService.getEventTypes()[propertyInfoPair.getFirst().getStreamNum()], firstItem.getName());
                if (firstItem.getParameters().size() > 1) {
                    throw new ExprValidationException("Property '" + firstItem.getName() + "' may not be accessed passing 2 or more parameters");
                }
                ExprEvaluator paramEval = firstItem.getParameters().get(0).getExprEvaluator();
                inputType = typeInfo = EPTypeHelper.singleValue(desc.getPropertyComponentType());
                getter = null;
                if (desc.isMapped()) {
                    if (paramEval.getType() != String.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getType()));
                    }
                    EventPropertyGetterMapped mappedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterMapped(propertyInfoPair.getFirst().getPropertyName());
                    if (mappedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaMapped(streamId, mappedGetter, paramEval, desc.getPropertyComponentType());
                }
                if (desc.isIndexed()) {
                    if (JavaClassHelper.getBoxedType(paramEval.getType()) != Integer.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getType()));
                    }
                    EventPropertyGetterIndexed indexedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterIndexed(propertyInfoPair.getFirst().getPropertyName());
                    if (indexedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaIndexed(streamId, indexedGetter, paramEval, desc.getPropertyComponentType());
                }
            }
            if (typeInfo == null) {
                throw new ExprValidationException("Property '" + propertyName + "' is not a mapped or indexed property");
            }
            ExprDotNodeFilterAnalyzerInputProp filterAnalyzerInputProp = new ExprDotNodeFilterAnalyzerInputProp(propertyInfoPair.getFirst().getStreamNum(), propertyInfoPair.getFirst().getPropertyName());
            boolean rootIsEventBean = false;
            try {
                evals = ExprDotNodeUtility.getChainEvaluators(streamId, inputType, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
            }
            catch (ExprValidationException ex) {
                FragmentEventType fragment = propertyInfoPair.getFirst().getFragmentEventType();
                if (fragment == null) {
                    throw ex;
                }
                EPType fragmentTypeInfo = fragment.isIndexed() ? EPTypeHelper.collectionOfEvents(fragment.getFragmentType()) : EPTypeHelper.singleEvent(fragment.getFragmentType());
                rootIsEventBean = true;
                evals = ExprDotNodeUtility.getChainEvaluators(propertyInfoPair.getFirst().getStreamNum(), fragmentTypeInfo, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
                rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaFragment(streamId, getter, fragment.getFragmentType().getUnderlyingType());
            }
            this.exprEvaluator = new ExprDotEvalRootChild(hasEnumerationMethod, this, rootNodeEvaluator, enumerationEval, inputType, evals.getChain(), evals.getChainWithUnpack(), !rootIsEventBean);
            this.exprDotNodeFilterAnalyzerDesc = evals.getFilterAnalyzerDesc();
            this.streamNumReferenced = propertyInfoPair.getFirst().getStreamNum();
            this.rootPropertyName = propertyInfoPair.getFirst().getPropertyName();
            return null;
        }
        String contextNameVariable = validationContext.getVariableService().isContextVariable(firstItem.getName());
        if (contextNameVariable != null) {
            throw new ExprValidationException("Method invocation on context-specific variable is not supported");
        }
        VariableReader variableReader = validationContext.getVariableService().getReader(firstItem.getName(), -1);
        if (variableReader != null) {
            ExprDotStaticMethodWrapArrayScalar wrap;
            EPType typeInfo;
            if (variableReader.getVariableMetaData().getType().isArray()) {
                typeInfo = EPTypeHelper.collectionOfSingleValue(variableReader.getVariableMetaData().getType().getComponentType());
                wrap = new ExprDotStaticMethodWrapArrayScalar(variableReader.getVariableMetaData().getVariableName(), variableReader.getVariableMetaData().getType().getComponentType());
            } else if (variableReader.getVariableMetaData().getEventType() != null) {
                typeInfo = EPTypeHelper.singleEvent(variableReader.getVariableMetaData().getEventType());
                wrap = null;
            } else {
                typeInfo = EPTypeHelper.singleValue(variableReader.getVariableMetaData().getType());
                wrap = null;
            }
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.exprEvaluator = new ExprDotEvalVariable(this, variableReader, wrap, evals.getChainWithUnpack());
            return null;
        }
        Object enumconstant = JavaClassHelper.resolveIdentAsEnumConst(firstItem.getName(), validationContext.getEngineImportService(), false);
        if (enumconstant != null) {
            final ExprChainedSpec methodSpec = (ExprChainedSpec)modifiedChain.get(0);
            final String enumvalue = firstItem.getName();
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception ex) {
                    return new ExprValidationException("Failed to resolve method '" + methodSpec.getName() + "' on enumeration value '" + enumvalue + "': " + ex.getMessage());
                }
            };
            EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
            ExprNodeUtilMethodDesc methodDesc = ExprNodeUtility.resolveMethodAllowWildcardAndStream(enumconstant.getClass().getName(), enumconstant.getClass(), methodSpec.getName(), methodSpec.getParameters(), validationContext.getEngineImportService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), wildcardType != null, wildcardType, handler, methodSpec.getName(), validationContext.getTableService(), streamTypeService.getEngineURIQualifier());
            modifiedChain.remove(0);
            ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(methodDesc.getReflectionMethod(), validationContext.getEventAdapterService(), modifiedChain, null);
            EPType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPTypeHelper.singleValue(methodDesc.getFastMethod().getReturnType());
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.exprEvaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), firstItem.getName(), methodDesc.getFastMethod(), methodDesc.getChildEvals(), false, optionalLambdaWrap, evals.getChainWithUnpack(), false, enumconstant);
            return null;
        }
        if (prefixedStreamNumException != null) {
            throw prefixedStreamNumException;
        }
        ExprChainedSpec secondItem = (ExprChainedSpec)modifiedChain.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        boolean isConstantParameters = (method = ExprNodeUtility.resolveMethodAllowWildcardAndStream(firstItem.getName(), null, secondItem.getName(), secondItem.getParameters(), validationContext.getEngineImportService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), allowWildcard, streamZeroType, new ExprNodeUtilResolveExceptionHandlerDefault(firstItem.getName() + "." + secondItem.getName(), false), secondItem.getName(), validationContext.getTableService(), streamTypeService.getEngineURIQualifier())).isAllConstants() && this.isUDFCache;
        this.isReturnsConstantResult = isConstantParameters && modifiedChain.isEmpty();
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method.getReflectionMethod(), validationContext.getEventAdapterService(), modifiedChain, null);
        EPType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPTypeHelper.singleValue(method.getReflectionMethod().getReturnType());
        ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(null, typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
        this.exprEvaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), firstItem.getName(), method.getFastMethod(), method.getChildEvals(), isConstantParameters, optionalLambdaWrap, evals.getChainWithUnpack(), false, null);
        return null;
    }

    @Override
    public ExprDotNodeFilterAnalyzerDesc getExprDotNodeFilterAnalyzerDesc() {
        return this.exprDotNodeFilterAnalyzerDesc;
    }

    private ExprEvaluator getPropertyPairEvaluator(ExprEvaluator parameterEval, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, ExprValidationContext validationContext) throws ExprValidationException {
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        EventPropertyDescriptor propertyDesc = EventTypeUtility.getNestablePropertyDescriptor(propertyInfoPair.getFirst().getStreamEventType(), propertyName);
        if (propertyDesc == null || !propertyDesc.isMapped() && !propertyDesc.isIndexed()) {
            throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + propertyName + "' could not be resolved");
        }
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        if (propertyDesc.isMapped()) {
            if (parameterEval.getType() != String.class) {
                throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
            }
            EventPropertyGetterMapped mappedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterMapped(propertyInfoPair.getFirst().getPropertyName());
            if (mappedGetter == null) {
                throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
            }
            return new ExprDotEvalPropertyExprMapped(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyComponentType(), mappedGetter);
        }
        if (JavaClassHelper.getBoxedType(parameterEval.getType()) != Integer.class) {
            throw new ExprValidationException("Parameter expression to indexed property '" + propertyDesc.getPropertyName() + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
        }
        EventPropertyGetterIndexed indexedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterIndexed(propertyInfoPair.getFirst().getPropertyName());
        if (indexedGetter == null) {
            throw new ExprValidationException("Indexed property named '" + propertyName + "' failed to obtain getter-object");
        }
        return new ExprDotEvalPropertyExprIndexed(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyComponentType(), indexedGetter);
    }

    private int prefixedStreamName(List<ExprChainedSpec> chainSpec, StreamTypeService streamTypeService) {
        if (chainSpec.size() < 1) {
            return -1;
        }
        ExprChainedSpec spec = chainSpec.get(0);
        if (spec.getParameters().size() > 0 && !spec.isProperty()) {
            return -1;
        }
        return streamTypeService.getStreamNumForStreamName(spec.getName());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtility.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    @Override
    public boolean isConstantResult() {
        return this.isReturnsConstantResult;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getChildNodes().length != 0) {
            writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.getChildNodes()[0]));
        }
        ExprNodeUtility.toExpressionString(this.chainSpec, writer, this.getChildNodes().length != 0, null);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.MINIMUM;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprDotNodeImpl)) {
            return false;
        }
        ExprDotNodeImpl other = (ExprDotNodeImpl)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtility.collectChainParameters(this.chainSpec);
    }

    @Override
    public String isVariableOpGetName(VariableService variableService) {
        VariableMetaData metaData = null;
        if (this.chainSpec.size() > 0 && this.chainSpec.get(0).isProperty()) {
            metaData = variableService.getVariableMetaData(this.chainSpec.get(0).getName());
        }
        return metaData == null ? null : metaData.getVariableName();
    }

    private ExprValidationException handleNotFound(String name) {
        return new ExprValidationException("Unknown single-row function, expression declaration, script or aggregation function named '" + name + "' could not be resolved");
    }
}

