/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;

public class ExprMethodAggUtil {
    public static ExprEvaluator getDefaultEvaluator(ExprNode[] childNodes, boolean join, EventType[] typesPerStream) throws ExprValidationException {
        ExprEvaluator evaluator = childNodes.length > 1 ? ExprMethodAggUtil.getMultiNodeEvaluator(childNodes, join, typesPerStream) : (childNodes.length > 0 ? (childNodes[0] instanceof ExprWildcard ? ExprMethodAggUtil.getWildcardEvaluator(typesPerStream, join) : childNodes[0].getExprEvaluator()) : new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                return null;
            }

            @Override
            public Class getType() {
                return null;
            }
        });
        return evaluator;
    }

    public static ExprEvaluator getMultiNodeEvaluator(ExprNode[] childNodes, boolean join, EventType[] typesPerStream) throws ExprValidationException {
        final ExprEvaluator[] evaluators = new ExprEvaluator[childNodes.length];
        int count = 0;
        for (ExprNode node : childNodes) {
            evaluators[count] = node instanceof ExprWildcard ? ExprMethodAggUtil.getWildcardEvaluator(typesPerStream, join) : node.getExprEvaluator();
            ++count;
        }
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                Object[] values = new Object[evaluators.length];
                for (int i = 0; i < evaluators.length; ++i) {
                    values[i] = evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                return values;
            }

            @Override
            public Class getType() {
                return Object[].class;
            }
        };
    }

    private static ExprEvaluator getWildcardEvaluator(EventType[] typesPerStream, boolean isJoin) throws ExprValidationException {
        Class returnType;
        Class clazz = returnType = typesPerStream != null && typesPerStream.length > 0 ? typesPerStream[0].getUnderlyingType() : null;
        if (isJoin || returnType == null) {
            throw new ExprValidationException("Invalid use of wildcard (*) for stream selection in a join or an empty from-clause, please use the stream-alias syntax to select a specific stream instead");
        }
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                EventBean event = eventsPerStream[0];
                if (event == null) {
                    return null;
                }
                return event.getUnderlying();
            }

            @Override
            public Class getType() {
                return returnType;
            }
        };
    }
}

