/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.bean.InstanceManufacturer;
import com.espertech.esper.event.bean.InstanceManufacturerFactory;
import java.io.StringWriter;

public class ExprNewInstanceNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = 1354077020397807076L;
    private final String classIdent;
    private transient Class targetClass;
    private transient InstanceManufacturer manufacturer;

    public ExprNewInstanceNode(String classIdent) {
        this.classIdent = classIdent;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        try {
            this.targetClass = validationContext.getEngineImportService().resolveClass(this.classIdent, false);
        }
        catch (EngineImportException e) {
            throw new ExprValidationException("Failed to resolve new-operator class name '" + this.classIdent + "'");
        }
        this.manufacturer = InstanceManufacturerFactory.getManufacturer(this.targetClass, validationContext.getEngineImportService(), this.getChildNodes());
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.manufacturer.make(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Class getType() {
        return this.targetClass;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public String getClassIdent() {
        return this.classIdent;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNewInstanceNode)) {
            return false;
        }
        ExprNewInstanceNode other = (ExprNewInstanceNode)node;
        return other.classIdent.equals(this.classIdent);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("new ");
        writer.write(this.classIdent);
        ExprNodeUtility.toExpressionStringParams(writer, this.getChildNodes());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }
}

