/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprOrNode
extends ExprNodeBase
implements ExprEvaluator {
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -1079540621551505814L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType)) continue;
            throw new ExprValidationException("Incorrect use of OR clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().length <= 1) {
            throw new ExprValidationException("The OR operator requires at least 2 child expressions");
        }
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = false;
        for (ExprEvaluator child : this.evaluators) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (evaluated == null) {
                result = null;
                continue;
            }
            if (!evaluated.booleanValue()) continue;
            return true;
        }
        return result;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(appendStr);
            child.toEPL(writer, this.getPrecedence());
            appendStr = " or ";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.OR;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprOrNode;
    }
}

