/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExprRegexpNode
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isNot;
    private Pattern pattern;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -837177267278295664L;

    public ExprRegexpNode(boolean not) {
        this.isNot = not;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("The regexp operator requires 2 child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class patternChildType = this.evaluators[1].getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The regexp operator requires a String-type pattern expression");
        }
        if (this.getChildNodes()[1].isConstantResult()) {
            this.isConstantPattern = true;
        }
        Class evalChildType = this.evaluators[0].getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The regexp operator requires a String or numeric type left-hand expression");
        }
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object evalValue;
        String patternText;
        if (this.pattern == null) {
            patternText = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if (!this.isConstantPattern) {
            patternText = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if ((evalValue = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext)) == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.pattern.matcher((CharSequence)evalValue).matches();
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprRegexpNode)) {
            return false;
        }
        ExprRegexpNode other = (ExprRegexpNode)node;
        return this.isNot == other.isNot;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isNot) {
            writer.append(" not");
        }
        writer.append(" regexp ");
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    public boolean isNot() {
        return this.isNot;
    }
}

