/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.subquery;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectExistsNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNR;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsAllAnyAggregated;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsAllDefault;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsAllWGroupBy;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsAnyDefault;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsAnyWGroupBy;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsInAggregated;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsInFiltered;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsInUnfiltered;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNREqualsInWGroupBy;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRExistsAggregated;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRExistsAlwaysTrue;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRExistsDefault;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRExistsWGroupBy;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRExistsWGroupByWHaving;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRRelOpAllAnyAggregated;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRRelOpAllDefault;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRRelOpAllWGroupBy;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRRelOpAnyDefault;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyNRRelOpAnyWGroupBy;
import com.espertech.esper.epl.spec.GroupByClauseExpressions;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.Collection;
import java.util.Map;

public class SubselectEvalStrategyNRFactory {
    public static SubselectEvalStrategyNR createStrategyExists(ExprSubselectExistsNode subselectExpression) {
        boolean aggregated = SubselectEvalStrategyNRFactory.aggregated(subselectExpression.getSubselectAggregationType());
        boolean grouped = SubselectEvalStrategyNRFactory.grouped(subselectExpression.getStatementSpecCompiled().getGroupByExpressions());
        if (grouped) {
            if (subselectExpression.havingExpr != null) {
                return new SubselectEvalStrategyNRExistsWGroupByWHaving(subselectExpression.havingExpr);
            }
            return SubselectEvalStrategyNRExistsWGroupBy.INSTANCE;
        }
        if (aggregated) {
            if (subselectExpression.havingExpr != null) {
                return new SubselectEvalStrategyNRExistsAggregated(subselectExpression.havingExpr);
            }
            return SubselectEvalStrategyNRExistsAlwaysTrue.INSTANCE;
        }
        return new SubselectEvalStrategyNRExistsDefault(subselectExpression.filterExpr, subselectExpression.havingExpr);
    }

    public static SubselectEvalStrategyNR createStrategyAnyAllIn(ExprSubselectNode subselectExpression, boolean isNot, boolean isAll, boolean isAny, RelationalOpEnum relationalOp) throws ExprValidationException {
        if (subselectExpression.getChildNodes().length != 1) {
            throw new ExprValidationException("The Subselect-IN requires 1 child expression");
        }
        ExprNode valueExpr = subselectExpression.getChildNodes()[0];
        Class typeOne = JavaClassHelper.getBoxedType(subselectExpression.getChildNodes()[0].getExprEvaluator().getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        Class typeTwo = subselectExpression.getSelectClause() != null ? subselectExpression.getSelectClause()[0].getExprEvaluator().getType() : subselectExpression.getRawEventType().getUnderlyingType();
        boolean aggregated = SubselectEvalStrategyNRFactory.aggregated(subselectExpression.getSubselectAggregationType());
        boolean grouped = SubselectEvalStrategyNRFactory.grouped(subselectExpression.getStatementSpecCompiled().getGroupByExpressions());
        ExprEvaluator selectEval = subselectExpression.getSelectClause() == null ? null : subselectExpression.getSelectClause()[0].getExprEvaluator();
        ExprEvaluator valueEval = valueExpr.getExprEvaluator();
        ExprEvaluator filterEval = subselectExpression.getFilterExpr();
        ExprEvaluator havingEval = subselectExpression.getHavingExpr();
        if (relationalOp != null) {
            if (typeOne != String.class || typeTwo != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            RelationalOpEnum.Computer computer = relationalOp.getComputer(compareType, typeOne, typeTwo);
            if (isAny) {
                if (grouped) {
                    return new SubselectEvalStrategyNRRelOpAnyWGroupBy(valueEval, selectEval, false, computer, havingEval);
                }
                if (aggregated) {
                    return new SubselectEvalStrategyNRRelOpAllAnyAggregated(valueEval, selectEval, false, computer, havingEval);
                }
                return new SubselectEvalStrategyNRRelOpAnyDefault(valueEval, selectEval, false, computer, filterEval);
            }
            if (grouped) {
                return new SubselectEvalStrategyNRRelOpAllWGroupBy(valueEval, selectEval, true, computer, havingEval);
            }
            if (aggregated) {
                return new SubselectEvalStrategyNRRelOpAllAnyAggregated(valueEval, selectEval, true, computer, havingEval);
            }
            return new SubselectEvalStrategyNRRelOpAllDefault(valueEval, selectEval, true, computer, filterEval);
        }
        SimpleNumberCoercer coercer = SubselectEvalStrategyNRFactory.getCoercer(typeOne, typeTwo);
        if (isAll) {
            if (grouped) {
                return new SubselectEvalStrategyNREqualsAllWGroupBy(valueEval, selectEval, true, isNot, coercer, havingEval);
            }
            if (aggregated) {
                return new SubselectEvalStrategyNREqualsAllAnyAggregated(valueEval, selectEval, true, isNot, coercer, havingEval);
            }
            return new SubselectEvalStrategyNREqualsAllDefault(valueEval, selectEval, true, isNot, coercer, filterEval);
        }
        if (isAny) {
            if (grouped) {
                return new SubselectEvalStrategyNREqualsAnyWGroupBy(valueEval, selectEval, false, isNot, coercer, havingEval);
            }
            if (aggregated) {
                return new SubselectEvalStrategyNREqualsAllAnyAggregated(valueEval, selectEval, true, isNot, coercer, havingEval);
            }
            return new SubselectEvalStrategyNREqualsAnyDefault(valueEval, selectEval, false, isNot, coercer, filterEval);
        }
        if (grouped) {
            return new SubselectEvalStrategyNREqualsInWGroupBy(valueEval, selectEval, isNot, coercer, havingEval);
        }
        if (aggregated) {
            return new SubselectEvalStrategyNREqualsInAggregated(valueEval, selectEval, isNot, coercer, havingEval);
        }
        if (filterEval == null) {
            return new SubselectEvalStrategyNREqualsInUnfiltered(valueEval, selectEval, isNot, coercer);
        }
        return new SubselectEvalStrategyNREqualsInFiltered(valueEval, selectEval, isNot, coercer, filterEval);
    }

    private static SimpleNumberCoercer getCoercer(Class typeOne, Class typeTwo) throws ExprValidationException {
        Class coercionType;
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        boolean mustCoerce = false;
        if ((coercionType != JavaClassHelper.getBoxedType(typeOne) || coercionType != JavaClassHelper.getBoxedType(typeTwo)) && JavaClassHelper.isNumeric(coercionType)) {
            mustCoerce = true;
        }
        return !mustCoerce ? null : SimpleNumberCoercerFactory.getCoercer(null, coercionType);
    }

    private static boolean grouped(GroupByClauseExpressions groupByExpressions) {
        return groupByExpressions != null && groupByExpressions.getGroupByNodes() != null && groupByExpressions.getGroupByNodes().length != 0;
    }

    private static boolean aggregated(ExprSubselectNode.SubqueryAggregationType subqueryAggregationType) {
        return subqueryAggregationType != null && subqueryAggregationType != ExprSubselectNode.SubqueryAggregationType.NONE;
    }
}

