/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.expression.accessagg.ExprAggregateAccessMultiValueNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.io.StringWriter;
import java.util.Collection;

public class ExprTableIdentNodeSubpropAccessor
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorEnumeration {
    private static final long serialVersionUID = -8308528998078977774L;
    private final int streamNum;
    private final String optionalStreamName;
    private final TableMetadataColumnAggregation tableAccessColumn;
    private final ExprNode aggregateAccessMultiValueNode;
    private transient AggregationMethodFactory accessorFactory;
    private transient AggregationAccessor accessor;

    public ExprTableIdentNodeSubpropAccessor(int streamNum, String optionalStreamName, TableMetadataColumnAggregation tableAccessColumn, ExprNode aggregateAccessMultiValueNode) {
        this.streamNum = streamNum;
        this.optionalStreamName = optionalStreamName;
        this.tableAccessColumn = tableAccessColumn;
        this.aggregateAccessMultiValueNode = aggregateAccessMultiValueNode;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.tableAccessColumn.getAccessAccessorSlotPair() == null) {
            throw new ExprValidationException("Invalid combination of aggregation state and aggregation accessor");
        }
        ExprAggregateAccessMultiValueNode mfNode = (ExprAggregateAccessMultiValueNode)((Object)this.aggregateAccessMultiValueNode);
        mfNode.validatePositionals();
        this.accessorFactory = mfNode.validateAggregationParamsWBinding(validationContext, this.tableAccessColumn);
        this.accessor = this.accessorFactory.getAccessor();
        return null;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getType() {
        return this.accessorFactory.getResultType();
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationState state = this.getState(eventsPerStream);
        if (state == null) {
            return null;
        }
        return this.accessor.getValue(state, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return ((ExprAggregateAccessMultiValueNode)((Object)this.aggregateAccessMultiValueNode)).getEventTypeCollection(eventAdapterService, statementId);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationState state = this.getState(eventsPerStream);
        if (state == null) {
            return null;
        }
        return this.accessor.getEnumerableEvents(state, eventsPerStream, isNewData, context);
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return ((ExprAggregateAccessMultiValueNode)((Object)this.aggregateAccessMultiValueNode)).getComponentTypeCollection();
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationState state = this.getState(eventsPerStream);
        if (state == null) {
            return null;
        }
        return this.accessor.getEnumerableScalar(state, eventsPerStream, isNewData, context);
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return ((ExprAggregateAccessMultiValueNode)((Object)this.aggregateAccessMultiValueNode)).getEventTypeSingle(eventAdapterService, statementId);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationState state = this.getState(eventsPerStream);
        if (state == null) {
            return null;
        }
        return this.accessor.getEnumerableEvent(state, eventsPerStream, isNewData, context);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.optionalStreamName != null) {
            writer.append(this.optionalStreamName);
            writer.append(".");
        }
        writer.append(this.tableAccessColumn.getColumnName());
        writer.append(".");
        this.aggregateAccessMultiValueNode.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return false;
    }

    private AggregationState getState(EventBean[] eventsPerStream) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow((ObjectArrayBackedEventBean)event);
        return row.getStates()[this.tableAccessColumn.getAccessAccessorSlotPair().getSlot()];
    }
}

