/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import com.espertech.esper.epl.expression.time.ExprTimePeriodUtil;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaNonConstCalAdd
implements ExprTimePeriodEvalDeltaNonConst {
    private final Calendar cal;
    private final ExprTimePeriodImpl parent;
    private final int indexMicroseconds;

    public ExprTimePeriodEvalDeltaNonConstCalAdd(TimeZone timeZone, ExprTimePeriodImpl parent) {
        this.parent = parent;
        this.cal = Calendar.getInstance(timeZone);
        this.indexMicroseconds = ExprTimePeriodUtil.findIndexMicroseconds(parent.getAdders());
    }

    @Override
    public synchronized long deltaAdd(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, 1, eventsPerStream, isNewData, context);
    }

    @Override
    public synchronized long deltaSubtract(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, -1, eventsPerStream, isNewData, context);
    }

    @Override
    public synchronized long deltaUseEngineTime(EventBean[] eventsPerStream, AgentInstanceContext agentInstanceContext) {
        long currentTime = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        return this.addSubtract(currentTime, 1, eventsPerStream, true, agentInstanceContext);
    }

    @Override
    public synchronized ExprTimePeriodEvalDeltaResult deltaAddWReference(long current, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long last;
        if (reference > current) {
            while (reference > current) {
                reference -= this.deltaSubtract(reference, eventsPerStream, isNewData, context);
            }
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next, eventsPerStream, isNewData, context)) <= current) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - current, last);
    }

    private long addSubtract(long currentTime, int factor, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        long remainder = this.parent.getTimeAbacus().calendarSet(currentTime, this.cal);
        ExprTimePeriodImpl.TimePeriodAdder[] adders = this.parent.getAdders();
        ExprEvaluator[] evaluators = this.parent.getEvaluators();
        int usec = 0;
        for (int i = 0; i < adders.length; ++i) {
            int value = ((Number)evaluators[i].evaluate(eventsPerStream, newData, context)).intValue();
            if (i == this.indexMicroseconds) {
                usec = value;
                continue;
            }
            adders[i].add(this.cal, factor * value);
        }
        long result = this.parent.getTimeAbacus().calendarGet(this.cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * usec);
        }
        return result - currentTime;
    }
}

