/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Calendar;
import java.util.Date;

public class TimeAbacusMicroseconds
implements TimeAbacus {
    public static final TimeAbacusMicroseconds INSTANCE = new TimeAbacusMicroseconds();
    private static final long serialVersionUID = -1581886702966700798L;

    private TimeAbacusMicroseconds() {
    }

    @Override
    public long deltaForSecondsDouble(double seconds) {
        return Math.round(1000000.0 * seconds);
    }

    @Override
    public long deltaForSecondsNumber(Number timeInSeconds) {
        if (JavaClassHelper.isFloatingPointNumber(timeInSeconds)) {
            return this.deltaForSecondsDouble(timeInSeconds.doubleValue());
        }
        return 1000000L * timeInSeconds.longValue();
    }

    @Override
    public long calendarSet(long fromTime, Calendar cal) {
        long millis = fromTime / 1000L;
        cal.setTimeInMillis(millis);
        return fromTime - millis * 1000L;
    }

    @Override
    public long calendarGet(Calendar cal, long remainder) {
        return cal.getTimeInMillis() * 1000L + remainder;
    }

    @Override
    public long getOneSecond() {
        return 1000000L;
    }

    @Override
    public Date toDate(long ts) {
        return new Date(ts / 1000L);
    }
}

