/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Calendar;
import java.util.Date;

public class TimeAbacusMilliseconds
implements TimeAbacus {
    public static final TimeAbacusMilliseconds INSTANCE = new TimeAbacusMilliseconds();
    private static final long serialVersionUID = 7634550048792013972L;

    private TimeAbacusMilliseconds() {
    }

    @Override
    public long deltaForSecondsDouble(double seconds) {
        return Math.round(1000.0 * seconds);
    }

    @Override
    public long deltaForSecondsNumber(Number timeInSeconds) {
        if (JavaClassHelper.isFloatingPointNumber(timeInSeconds)) {
            return this.deltaForSecondsDouble(timeInSeconds.doubleValue());
        }
        return 1000L * timeInSeconds.longValue();
    }

    @Override
    public long calendarSet(long fromTime, Calendar cal) {
        cal.setTimeInMillis(fromTime);
        return 0L;
    }

    @Override
    public long calendarGet(Calendar cal, long remainder) {
        return cal.getTimeInMillis();
    }

    @Override
    public long getOneSecond() {
        return 1000L;
    }

    @Override
    public Date toDate(long ts) {
        return new Date(ts);
    }
}

