/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.epl.db.DataCacheClearableMap;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerHistoricalImpl
implements JoinSetComposer {
    private final boolean allowInitIndex;
    private final EventTable[][] repositories;
    private final QueryStrategy[] queryStrategies;
    private Set<MultiKey<EventBean>> oldResults = new LinkedHashSet<MultiKey<EventBean>>();
    private Set<MultiKey<EventBean>> newResults = new LinkedHashSet<MultiKey<EventBean>>();
    private EventTable[][] tables = new EventTable[0][];
    private Viewable[] streamViews;
    private ExprEvaluatorContext staticEvalExprEvaluatorContext;

    public JoinSetComposerHistoricalImpl(boolean allowInitIndex, Map<TableLookupIndexReqKey, EventTable>[] repositories, QueryStrategy[] queryStrategies, Viewable[] streamViews, ExprEvaluatorContext staticEvalExprEvaluatorContext) {
        this.allowInitIndex = allowInitIndex;
        this.repositories = JoinSetComposerUtil.toArray(repositories, streamViews.length);
        this.queryStrategies = queryStrategies;
        this.streamViews = streamViews;
        this.staticEvalExprEvaluatorContext = staticEvalExprEvaluatorContext;
    }

    @Override
    public boolean allowsInit() {
        return this.allowInitIndex;
    }

    @Override
    public void init(EventBean[][] eventsPerStream) {
        if (!this.allowInitIndex) {
            throw new IllegalStateException("Initialization by events not supported");
        }
        if (this.repositories == null) {
            return;
        }
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null || this.repositories[i] == null) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i]);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.repositories == null) {
            return;
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (this.repositories[i] == null) continue;
            for (EventTable table : this.repositories[i]) {
                table.destroy();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKey<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        this.oldResults.clear();
        this.newResults.clear();
        for (i = 0; i < oldDataPerStream.length; ++i) {
            if (oldDataPerStream[i] == null) continue;
            this.queryStrategies[i].lookup(oldDataPerStream[i], this.oldResults, exprEvaluatorContext);
        }
        if (this.repositories != null) {
            for (int stream = 0; stream < newDataPerStream.length; ++stream) {
                for (int j = 0; j < this.repositories[stream].length; ++j) {
                    this.repositories[stream][j].addRemove(newDataPerStream[stream], oldDataPerStream[stream]);
                }
            }
        }
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null) continue;
            this.queryStrategies[i].lookup(newDataPerStream[i], this.newResults, exprEvaluatorContext);
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(this.newResults, this.oldResults);
    }

    protected EventTable[][] getTables() {
        return this.tables;
    }

    protected QueryStrategy[] getQueryStrategies() {
        return this.queryStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        LinkedHashSet<MultiKey<EventBean>> result = new LinkedHashSet<MultiKey<EventBean>>();
        EventBean[] lookupEvents = new EventBean[1];
        DataCacheClearableMap[] caches = new DataCacheClearableMap[this.queryStrategies.length];
        this.assignThreadLocalCache(this.streamViews, caches);
        try {
            int stream = 0;
            while (stream < this.queryStrategies.length) {
                block8: {
                    block7: {
                        if (!(this.streamViews[stream] instanceof HistoricalEventViewable)) break block7;
                        HistoricalEventViewable historicalViewable = (HistoricalEventViewable)this.streamViews[stream];
                        if (!historicalViewable.hasRequiredStreams() && this.queryStrategies[stream] != null) {
                            Iterator<EventBean> streamEvents = historicalViewable.iterator();
                            while (streamEvents.hasNext()) {
                                lookupEvents[0] = streamEvents.next();
                                this.queryStrategies[stream].lookup(lookupEvents, result, this.staticEvalExprEvaluatorContext);
                            }
                        }
                        break block8;
                    }
                    Iterator<EventBean> streamEvents = this.streamViews[stream].iterator();
                    while (streamEvents.hasNext()) {
                        lookupEvents[0] = streamEvents.next();
                        this.queryStrategies[stream].lookup(lookupEvents, result, this.staticEvalExprEvaluatorContext);
                    }
                }
                ++stream;
            }
            return result;
        }
        finally {
            this.deassignThreadLocalCache(this.streamViews, caches);
        }
    }

    @Override
    public void visitIndexes(StatementAgentInstancePostLoadIndexVisitor visitor) {
        visitor.visit(this.repositories);
    }

    private void assignThreadLocalCache(Viewable[] streamViews, DataCacheClearableMap[] caches) {
        for (int stream = 0; stream < streamViews.length; ++stream) {
            if (!(streamViews[stream] instanceof HistoricalEventViewable)) continue;
            HistoricalEventViewable historicalViewable = (HistoricalEventViewable)streamViews[stream];
            caches[stream] = new DataCacheClearableMap();
            historicalViewable.getDataCacheThreadLocal().set(caches[stream]);
        }
    }

    private void deassignThreadLocalCache(Viewable[] streamViews, DataCacheClearableMap[] caches) {
        for (int stream = 0; stream < streamViews.length; ++stream) {
            if (!(streamViews[stream] instanceof HistoricalEventViewable)) continue;
            HistoricalEventViewable historicalViewable = (HistoricalEventViewable)streamViews[stream];
            historicalViewable.getDataCacheThreadLocal().set(null);
            caches[stream].clear();
        }
    }
}

