/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.epl.join.base.ExecNodeQueryStrategy;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposer;
import com.espertech.esper.epl.join.base.JoinSetComposerAllUnidirectionalOuter;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerFAFImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.JoinSetComposerStreamToWinImpl;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.lookup.EventTableIndexService;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.epl.virtualdw.VirtualDWViewProviderForAgentInstance;
import com.espertech.esper.view.DerivedValueView;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinSetComposerPrototypeImpl
implements JoinSetComposerPrototype {
    private static final Logger log = LoggerFactory.getLogger(JoinSetComposerPrototypeFactory.class);
    private final String statementName;
    private final int statementId;
    private final OuterJoinDesc[] outerJoinDescList;
    private final ExprNode optionalFilterNode;
    private final EventType[] streamTypes;
    private final String[] streamNames;
    private final StreamJoinAnalysisResult streamJoinAnalysisResult;
    private final Annotation[] annotations;
    private final HistoricalViewableDesc historicalViewableDesc;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final QueryPlanIndex[] indexSpecs;
    private final QueryPlan queryPlan;
    private final HistoricalStreamIndexList[] historicalStreamIndexLists;
    private final boolean joinRemoveStream;
    private final boolean isOuterJoins;
    private final TableService tableService;
    private final EventTableIndexService eventTableIndexService;

    public JoinSetComposerPrototypeImpl(String statementName, int statementId, OuterJoinDesc[] outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, String[] streamNames, StreamJoinAnalysisResult streamJoinAnalysisResult, Annotation[] annotations, HistoricalViewableDesc historicalViewableDesc, ExprEvaluatorContext exprEvaluatorContext, QueryPlanIndex[] indexSpecs, QueryPlan queryPlan, HistoricalStreamIndexList[] historicalStreamIndexLists, boolean joinRemoveStream, boolean isOuterJoins, TableService tableService, EventTableIndexService eventTableIndexService) {
        this.statementName = statementName;
        this.statementId = statementId;
        this.outerJoinDescList = outerJoinDescList;
        this.optionalFilterNode = optionalFilterNode;
        this.streamTypes = streamTypes;
        this.streamNames = streamNames;
        this.streamJoinAnalysisResult = streamJoinAnalysisResult;
        this.annotations = annotations;
        this.historicalViewableDesc = historicalViewableDesc;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.indexSpecs = indexSpecs;
        this.queryPlan = queryPlan;
        this.historicalStreamIndexLists = historicalStreamIndexLists;
        this.joinRemoveStream = joinRemoveStream;
        this.isOuterJoins = isOuterJoins;
        this.tableService = tableService;
        this.eventTableIndexService = eventTableIndexService;
    }

    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        JoinSetComposerDesc joinSetComposerDesc;
        Map<Object, Object>[] indexesPerStream = new HashMap[this.indexSpecs.length];
        Lock[] tableSecondaryIndexLocks = new Lock[this.indexSpecs.length];
        boolean hasTable = false;
        for (int streamNo = 0; streamNo < this.indexSpecs.length; ++streamNo) {
            EventTable index;
            if (this.indexSpecs[streamNo] == null) continue;
            Map<TableLookupIndexReqKey, QueryPlanIndexItem> items = this.indexSpecs[streamNo].getItems();
            indexesPerStream[streamNo] = new LinkedHashMap();
            if (this.streamJoinAnalysisResult.getTablesPerStream()[streamNo] != null) {
                TableMetadata metadata = this.streamJoinAnalysisResult.getTablesPerStream()[streamNo];
                TableStateInstance tableStateInstance = this.tableService.getState(metadata.getTableName(), agentInstanceContext.getAgentInstanceId());
                for (String indexName : tableStateInstance.getSecondaryIndexes()) {
                    EventTable index2 = tableStateInstance.getIndex(indexName);
                    indexesPerStream[streamNo].put(new TableLookupIndexReqKey(indexName, metadata.getTableName()), index2);
                }
                index = tableStateInstance.getIndex(metadata.getTableName());
                indexesPerStream[streamNo].put(new TableLookupIndexReqKey(metadata.getTableName(), metadata.getTableName()), index);
                hasTable = true;
                tableSecondaryIndexLocks[streamNo] = agentInstanceContext.getStatementContext().isWritesToTables() ? tableStateInstance.getTableLevelRWLock().writeLock() : tableStateInstance.getTableLevelRWLock().readLock();
                continue;
            }
            for (Map.Entry entry : items.entrySet()) {
                if (this.streamJoinAnalysisResult.getViewExternal()[streamNo] != null) {
                    VirtualDWView view = this.streamJoinAnalysisResult.getViewExternal()[streamNo].getView(agentInstanceContext);
                    index = view.getJoinIndexTable(items.get(entry.getKey()));
                } else {
                    index = EventTableUtil.buildIndex(agentInstanceContext, streamNo, items.get(entry.getKey()), this.streamTypes[streamNo], false, ((QueryPlanIndexItem)entry.getValue()).isUnique(), null, null, isFireAndForget);
                }
                indexesPerStream[streamNo].put(entry.getKey(), index);
            }
        }
        VirtualDWViewProviderForAgentInstance[] externalViewProviders = this.streamJoinAnalysisResult.getViewExternal();
        VirtualDWView[] externalViews = new VirtualDWView[externalViewProviders.length];
        for (int i = 0; i < externalViews.length; ++i) {
            if (externalViewProviders[i] == null) continue;
            externalViews[i] = this.streamJoinAnalysisResult.getViewExternal()[i].getView(agentInstanceContext);
        }
        QueryPlanNode[] queryExecSpecs = this.queryPlan.getExecNodeSpecs();
        QueryStrategy[] queryStrategyArray = new QueryStrategy[queryExecSpecs.length];
        for (int i = 0; i < queryExecSpecs.length; ++i) {
            QueryPlanNode planNode = queryExecSpecs[i];
            if (planNode == null) {
                log.debug(".makeComposer No execution node for stream " + i + " '" + this.streamNames[i] + "'");
                continue;
            }
            ExecNode executionNode = planNode.makeExec(this.statementName, this.statementId, this.annotations, indexesPerStream, this.streamTypes, streamViews, this.historicalStreamIndexLists, externalViews, tableSecondaryIndexLocks);
            if (log.isDebugEnabled()) {
                log.debug(".makeComposer Execution nodes for stream " + i + " '" + this.streamNames[i] + "' : \n" + ExecNode.print(executionNode));
            }
            queryStrategyArray[i] = new ExecNodeQueryStrategy(i, this.streamTypes.length, executionNode);
        }
        if (hasTable) {
            indexesPerStream = this.removeTableIndexes(indexesPerStream, this.streamJoinAnalysisResult.getTablesPerStream());
        }
        if (!(this.streamJoinAnalysisResult.isUnidirectional() || this.streamJoinAnalysisResult.isPureSelfJoin() && this.outerJoinDescList.length <= 0)) {
            JoinSetComposer composer = this.historicalViewableDesc.isHasHistorical() ? new JoinSetComposerHistoricalImpl(this.eventTableIndexService.allowInitIndex(isRecoveringResilient), indexesPerStream, queryStrategyArray, streamViews, this.exprEvaluatorContext) : (isFireAndForget ? new JoinSetComposerFAFImpl(indexesPerStream, queryStrategyArray, this.streamJoinAnalysisResult.isPureSelfJoin(), this.exprEvaluatorContext, this.joinRemoveStream, this.isOuterJoins) : new JoinSetComposerImpl(this.eventTableIndexService.allowInitIndex(isRecoveringResilient), indexesPerStream, queryStrategyArray, this.streamJoinAnalysisResult.isPureSelfJoin(), this.exprEvaluatorContext, this.joinRemoveStream));
            ExprNode filterExpression = this.getFilterExpressionInclOnClause(this.optionalFilterNode, this.outerJoinDescList);
            ExprEvaluator postJoinEval = filterExpression == null ? null : filterExpression.getExprEvaluator();
            joinSetComposerDesc = new JoinSetComposerDesc(composer, postJoinEval);
        } else {
            ExprEvaluator postJoinEval;
            ExprEvaluator exprEvaluator = postJoinEval = this.optionalFilterNode == null ? null : this.optionalFilterNode.getExprEvaluator();
            if (this.streamJoinAnalysisResult.isUnidirectionalAll()) {
                JoinSetComposerAllUnidirectionalOuter composer = new JoinSetComposerAllUnidirectionalOuter(queryStrategyArray);
                joinSetComposerDesc = new JoinSetComposerDesc(composer, postJoinEval);
            } else {
                QueryStrategy driver;
                int unidirectionalStream;
                if (this.streamJoinAnalysisResult.isUnidirectional()) {
                    unidirectionalStream = this.streamJoinAnalysisResult.getUnidirectionalStreamNumberFirst();
                    driver = queryStrategyArray[unidirectionalStream];
                } else {
                    unidirectionalStream = 0;
                    driver = queryStrategyArray[0];
                }
                JoinSetComposerStreamToWinImpl composer = new JoinSetComposerStreamToWinImpl(this.eventTableIndexService.allowInitIndex(isRecoveringResilient), indexesPerStream, this.streamJoinAnalysisResult.isPureSelfJoin(), unidirectionalStream, driver, this.streamJoinAnalysisResult.getUnidirectionalNonDriving());
                joinSetComposerDesc = new JoinSetComposerDesc(composer, postJoinEval);
            }
        }
        if (joinSetComposerDesc.getJoinSetComposer().allowsInit()) {
            EventBean[][] eventsPerStream = new EventBean[this.streamNames.length][];
            ArrayList events = new ArrayList();
            for (int i = 0; i < eventsPerStream.length; ++i) {
                if (this.streamJoinAnalysisResult.getNamedWindow()[i] || this.streamJoinAnalysisResult.getTablesPerStream()[i] != null) continue;
                Iterator<EventBean> it = null;
                if (!(streamViews[i] instanceof HistoricalEventViewable) && !(streamViews[i] instanceof DerivedValueView)) {
                    try {
                        it = streamViews[i].iterator();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if (it != null) {
                    while (it.hasNext()) {
                        events.add(it.next());
                    }
                    eventsPerStream[i] = events.toArray(new EventBean[events.size()]);
                    events.clear();
                    continue;
                }
                eventsPerStream[i] = new EventBean[0];
            }
            joinSetComposerDesc.getJoinSetComposer().init(eventsPerStream);
        }
        return joinSetComposerDesc;
    }

    private Map<TableLookupIndexReqKey, EventTable>[] removeTableIndexes(Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, TableMetadata[] tablesPerStream) {
        Map[] result = new Map[indexesPerStream.length];
        for (int i = 0; i < indexesPerStream.length; ++i) {
            result[i] = tablesPerStream[i] == null ? indexesPerStream[i] : Collections.emptyMap();
        }
        return result;
    }

    private ExprNode getFilterExpressionInclOnClause(ExprNode optionalFilterNode, OuterJoinDesc[] outerJoinDescList) {
        if (optionalFilterNode == null) {
            return null;
        }
        if (outerJoinDescList.length == 0) {
            return optionalFilterNode;
        }
        if (!OuterJoinDesc.consistsOfAllInnerJoins(outerJoinDescList)) {
            return optionalFilterNode;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        andNode.addChildNode(optionalFilterNode);
        for (OuterJoinDesc outerJoinDesc : outerJoinDescList) {
            andNode.addChildNode(outerJoinDesc.makeExprNode(null));
        }
        try {
            andNode.validate(null);
        }
        catch (ExprValidationException ex) {
            throw new RuntimeException("Unexpected exception validating expression: " + ex.getMessage(), ex);
        }
        return andNode;
    }
}

