/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryFactory;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeTableLookupStrategy
implements JoinExecTableLookupStrategy {
    private final EventType eventType;
    private final PropertyCompositeEventTable index;
    private final CompositeIndexQuery chain;
    private final List<QueryGraphValueEntryRange> rangeKeyPairs;
    private final LookupStrategyDesc lookupStrategyDesc;

    public CompositeTableLookupStrategy(EventType eventType, int lookupStream, List<QueryGraphValueEntryHashKeyed> hashKeys, List<QueryGraphValueEntryRange> rangeKeyPairs, PropertyCompositeEventTable index) {
        this.eventType = eventType;
        this.index = index;
        this.rangeKeyPairs = rangeKeyPairs;
        this.chain = CompositeIndexQueryFactory.makeJoinSingleLookupStream(false, lookupStream, hashKeys, index.getOptKeyCoercedTypes(), rangeKeyPairs, index.getOptRangeCoercedTypes());
        ArrayDeque<String> expressionTexts = new ArrayDeque<String>();
        for (QueryGraphValueEntryRange pair : rangeKeyPairs) {
            ExprNode[] expressions;
            for (ExprNode node : expressions = pair.getExpressions()) {
                expressionTexts.add(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(node));
            }
        }
        this.lookupStrategyDesc = new LookupStrategyDesc(LookupStrategyType.COMPOSITE, expressionTexts.toArray(new String[expressionTexts.size()]));
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public PropertyCompositeEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext context) {
        Set<EventBean> result = this.chain.get(theEvent, (Map)this.index.getIndex(), context, this.index.getPostProcessor());
        if (result != null && result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.lookupStrategyDesc;
    }

    public String toString() {
        return "CompositeTableLookupStrategy indexProps=" + Arrays.toString(this.rangeKeyPairs.toArray()) + " index=(" + this.index + ')';
    }
}

