/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupUtil;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import java.util.Set;

public class InKeywordMultiTableLookupStrategyExpr
implements JoinExecTableLookupStrategy {
    private final PropertyIndexedEventTableSingle[] indexes;
    private final int streamNum;
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator evaluator;
    private final LookupStrategyDesc lookupStrategyDesc;

    public InKeywordMultiTableLookupStrategyExpr(ExprEvaluator evaluator, int streamNum, PropertyIndexedEventTableSingle[] indexes, LookupStrategyDesc lookupStrategyDesc) {
        if (indexes == null) {
            throw new IllegalArgumentException("Unexpected null index received");
        }
        this.indexes = indexes;
        this.streamNum = streamNum;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.evaluator = evaluator;
        this.lookupStrategyDesc = lookupStrategyDesc;
    }

    public PropertyIndexedEventTableSingle[] getIndex() {
        return this.indexes;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[this.streamNum] = theEvent;
        return InKeywordTableLookupUtil.multiIndexLookup(this.evaluator, this.eventsPerStream, exprEvaluatorContext, this.indexes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.lookupStrategyDesc.toString();
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.lookupStrategyDesc;
    }
}

