/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.base.CompositeTableLookupStrategy;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import java.util.List;

public class CompositeTableLookupPlan
extends TableLookupPlan {
    private final List<QueryGraphValueEntryHashKeyed> hashKeys;
    private final List<QueryGraphValueEntryRange> rangeKeyPairs;

    public CompositeTableLookupPlan(int lookupStream, int indexedStream, TableLookupIndexReqKey indexNum, List<QueryGraphValueEntryHashKeyed> hashKeys, List<QueryGraphValueEntryRange> rangeKeyPairs) {
        super(lookupStream, indexedStream, new TableLookupIndexReqKey[]{indexNum});
        this.hashKeys = hashKeys;
        this.rangeKeyPairs = rangeKeyPairs;
    }

    @Override
    public TableLookupKeyDesc getKeyDescriptor() {
        return new TableLookupKeyDesc(this.hashKeys, this.rangeKeyPairs);
    }

    @Override
    public JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] eventTable, EventType[] eventTypes) {
        PropertyCompositeEventTable index = (PropertyCompositeEventTable)eventTable[0];
        return new CompositeTableLookupStrategy(eventTypes[this.getLookupStream()], this.getLookupStream(), this.hashKeys, this.rangeKeyPairs, index);
    }

    @Override
    public String toString() {
        return "CompositeTableLookupPlan " + super.toString() + " directKeys=" + QueryGraphValueEntryHashKeyed.toQueryPlan(this.hashKeys) + " rangeKeys=" + QueryGraphValueEntryRange.toQueryPlan(this.rangeKeyPairs);
    }
}

